package com.zehong.web.controller.train;

import java.util.List;

import com.zehong.system.domain.vo.BatchTopicVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TTrainCourseTopic;
import com.zehong.system.service.ITTrainCourseTopicService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 培训课程题库Controller
 * 
 * @author zehong
 * @date 2022-09-19
 */
@Api("课程题库")
@RestController
@RequestMapping("/system/topic")
public class TTrainCourseTopicController extends BaseController
{
    @Autowired
    private ITTrainCourseTopicService tTrainCourseTopicService;

    /**
     * 查询培训课程题库列表
     */
    @ApiOperation("课程题库列表")
    @GetMapping("/list")
    public TableDataInfo list(TTrainCourseTopic tTrainCourseTopic)
    {
        startPage();
        List<TTrainCourseTopic> list = tTrainCourseTopicService.selectTTrainCourseTopicList(tTrainCourseTopic);
        return getDataTable(list);
    }
    @ApiOperation("课程题库列表（没答案）")
    @GetMapping("/topiclist")
    public AjaxResult CourseTopicList( Long courseId)
    {
        List<TTrainCourseTopic> list = tTrainCourseTopicService.selectCourseTopicList(courseId);
        return AjaxResult.success(list);
    }
    /**
     * 导出培训课程题库列表
     */
    @Log(title = "培训课程题库", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TTrainCourseTopic tTrainCourseTopic)
    {
        List<TTrainCourseTopic> list = tTrainCourseTopicService.selectTTrainCourseTopicList(tTrainCourseTopic);
        ExcelUtil<TTrainCourseTopic> util = new ExcelUtil<TTrainCourseTopic>(TTrainCourseTopic.class);
        return util.exportExcel(list, "培训课程题库数据");
    }

    /**
     * 获取培训课程题库详细信息
     */
    @ApiOperation("课程题详情")
    @GetMapping(value = "/{topicId}")
    public AjaxResult getInfo(@PathVariable("topicId") Long topicId)
    {
        return AjaxResult.success(tTrainCourseTopicService.selectTTrainCourseTopicById(topicId));
    }

    /**
     * 新增培训课程题库
     */
    @ApiOperation("添加课程题")
    @Log(title = "培训课程题库", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TTrainCourseTopic tTrainCourseTopic)
    {
        if(tTrainCourseTopic.getCourseId()==null||tTrainCourseTopic.getCourseId().equals("")){
            return AjaxResult.error("课程id不可为空");
        }
        return toAjax(tTrainCourseTopicService.insertTTrainCourseTopic(tTrainCourseTopic));
    }

    /**
     * 修改培训课程题库
     */
    @ApiOperation("修改课程题")
    @Log(title = "培训课程题库", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TTrainCourseTopic tTrainCourseTopic)
    {
        return toAjax(tTrainCourseTopicService.updateTTrainCourseTopic(tTrainCourseTopic));
    }

    /**
     * 删除培训课程题库
     */
//    @Log(title = "培训课程题库", businessType = BusinessType.DELETE)
//	@DeleteMapping("/{topicIds}")
//    public AjaxResult remove(@PathVariable Long[] topicIds)
//    {
//        return toAjax(tTrainCourseTopicService.deleteTTrainCourseTopicByIds(topicIds));
//    }

    /**
     * 删除培训课程题库
     */
    @ApiOperation("删除课程题")
    @Log(title = "培训课程题库", businessType = BusinessType.DELETE)
    @DeleteMapping("/{topicId}")
    public AjaxResult deleteTopic(@PathVariable Long topicId)
    {
        return toAjax(tTrainCourseTopicService.deleteTTrainCourseTopicById(topicId));
    }

    /**
     * 题库批量导入试题
     * @param batchTopicVo 试题实体
     * @return AjaxResult
     */
    @PostMapping("/bachAddTopic")
    public AjaxResult bachAddTopic(@RequestBody BatchTopicVo batchTopicVo){
        return toAjax(tTrainCourseTopicService.bachAddTopic(batchTopicVo));
    }
}
