package com.zehong.web.controller.system;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TTrainCourseBank;
import com.zehong.system.service.ITTrainCourseBankService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * bankController
 * 题库管理
 * @author zehong
 * @date 2022-12-14
 */
@RestController
@RequestMapping("/system/bank")
public class TTrainCourseBankController extends BaseController
{
    @Autowired
    private ITTrainCourseBankService tTrainCourseBankService;

    /**
     * 查询题库列表
     */
    //@PreAuthorize("@ss.hasPermi('system:bank:list')")
    @GetMapping("/list")
    public TableDataInfo list(TTrainCourseBank tTrainCourseBank)
    {
        startPage();
        System.out.println(tTrainCourseBank);
        List<TTrainCourseBank> list = tTrainCourseBankService.selectTTrainCourseBankList(tTrainCourseBank);
        return getDataTable(list);
    }

    /**
     * 导出题库列表
     */
    //@PreAuthorize("@ss.hasPermi('system:bank:export')")
    @Log(title = "bank", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TTrainCourseBank tTrainCourseBank)
    {
        List<TTrainCourseBank> list = tTrainCourseBankService.selectTTrainCourseBankList(tTrainCourseBank);
        ExcelUtil<TTrainCourseBank> util = new ExcelUtil<TTrainCourseBank>(TTrainCourseBank.class);
        return util.exportExcel(list, "bank数据");
    }

    /**
     * 获取bank详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:bank:query')")
    @GetMapping(value = "/{bankId}")
    public AjaxResult getInfo(@PathVariable("bankId") Long bankId)
    {
        return AjaxResult.success(tTrainCourseBankService.selectTTrainCourseBankById(bankId));
    }

    /**
     * 新增题库
     */
    //@PreAuthorize("@ss.hasPermi('system:bank:add')")
    @Log(title = "bank", businessType = BusinessType.INSERT)
    @PostMapping
    public int add(@RequestBody TTrainCourseBank tTrainCourseBank)
    {
        tTrainCourseBankService.insertTTrainCourseBank(tTrainCourseBank);
        return Math.toIntExact(tTrainCourseBank.getBankId());
    }

    /**
     * 修改bank
     */
    //@PreAuthorize("@ss.hasPermi('system:bank:edit')")
    @Log(title = "bank", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TTrainCourseBank tTrainCourseBank)
    {
        return toAjax(tTrainCourseBankService.updateTTrainCourseBank(tTrainCourseBank));
    }

    /**
     * 删除bank
     */
    //@PreAuthorize("@ss.hasPermi('system:bank:remove')")
    @Log(title = "bank", businessType = BusinessType.DELETE)
	@DeleteMapping("/{bankIds}")
    public AjaxResult remove(@PathVariable Long[] bankIds)
    {
        return toAjax(tTrainCourseBankService.deleteTTrainCourseBankByIds(bankIds));
    }
}
