package com.zehong.web.controller.system;
import java.util.List;

import com.zehong.system.domain.TNfcRecord;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TNfcSetting;
import com.zehong.system.service.ITNfcSettingService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * settingController
 *
 * @author zehong
 * @date 2022-10-17
 */
@RestController
@RequestMapping("/system/inspection")
public class TNfcSettingController extends BaseController
{
    @Autowired
    private ITNfcSettingService tNfcSettingService;

    /**
     * 查询巡检列表
     */
    //@PreAuthorize("@ss.hasPermi('system:setting:list')")
    @GetMapping("/list")
    public TableDataInfo list(TNfcSetting tNfcSetting)
    {
        startPage();
        List<TNfcSetting> list = tNfcSettingService.selectTNfcSettingList(tNfcSetting);
        return getDataTable(list);
    }

    /**
     * 巡检打卡查询列表
     * @param tNfcSetting
     * @return
     */
    @GetMapping("/punchClockList")
    public TableDataInfo punchClockList(TNfcSetting tNfcSetting){
        startPage();
        List<TNfcRecord> list = tNfcSettingService.punchClockList(tNfcSetting);
        return getDataTable(list);
    }

    /**
     * 导出巡检打卡列表
     */
    @Log(title = "setting", businessType = BusinessType.EXPORT)
    @GetMapping("/exportPunchClockList")
    public AjaxResult exportPunchClockList(TNfcSetting tNfcSetting)
    {
        List<TNfcRecord> list = tNfcSettingService.punchClockList(tNfcSetting);
        ExcelUtil<TNfcRecord> util = new ExcelUtil<TNfcRecord>(TNfcRecord.class);
        return util.exportExcel(list, "巡检打卡数据");
    }

    /**
     * 导出巡检列表
     */
    //@PreAuthorize("@ss.hasPermi('system:setting:export')")
    @Log(title = "setting", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TNfcSetting tNfcSetting)
    {
        List<TNfcSetting> list = tNfcSettingService.selectTNfcSettingList(tNfcSetting);
        ExcelUtil<TNfcSetting> util = new ExcelUtil<TNfcSetting>(TNfcSetting.class);
        return util.exportExcel(list, "setting数据");
    }

    /**
     * 获取巡检详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:setting:query')")
    @GetMapping(value = "/{nfcId}")
    public AjaxResult getInfo(@PathVariable("nfcId") Long nfcId)
    {
        return AjaxResult.success(tNfcSettingService.selectTNfcSettingById(nfcId));
    }

    /**
     * 巡检打卡详细信息
     * @param recordId
     * @return
     */
    @GetMapping(value = "getPunchClockList/{recordId}")
    public AjaxResult getPunchClockList( @PathVariable("recordId") Long recordId)
    {
        return AjaxResult.success(tNfcSettingService.getPunchClockList(recordId));
    }

    /**
     * 根据nfcNum获取巡检详细信息
     */
    @GetMapping(value = "/selectByNfcNum")
    public AjaxResult getInfoByNfcNum(String nfcNum)
    {
        return AjaxResult.success(tNfcSettingService.getInfoByNfcNum(nfcNum));
    }
    /**
     * 新增巡检
     */
    //@PreAuthorize("@ss.hasPermi('system:setting:add')")
    @Log(title = "setting", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TNfcSetting tNfcSetting)
    {
        System.out.println(tNfcSetting);
        return toAjax(tNfcSettingService.insertTNfcSetting(tNfcSetting));
    }

    /**
     * 修改巡检
     */
    //@PreAuthorize("@ss.hasPermi('system:setting:edit')")
    @Log(title = "setting", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TNfcSetting tNfcSetting)
    {
        return toAjax(tNfcSettingService.updateTNfcSetting(tNfcSetting));
    }

    /**
     * 删除巡检
     */
    //@PreAuthorize("@ss.hasPermi('system:setting:remove')")
    @Log(title = "setting", businessType = BusinessType.DELETE)
	@DeleteMapping("/{nfcIds}")
    public AjaxResult remove(@PathVariable Long[] nfcIds)
    {
        return toAjax(tNfcSettingService.deleteTNfcSettingByIds(nfcIds));
    }
}
