package com.zehong.web.controller.system;

import java.util.List;

import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.utils.ServletUtils;
import com.zehong.framework.web.service.TokenService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TNfcRecord;
import com.zehong.system.service.ITNfcRecordService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * nfc巡检记录idController
 * 
 * @author zehong
 * @date 2022-10-18
 */
@RestController
@RequestMapping("/system/record")
public class TNfcRecordController extends BaseController
{
    @Autowired
    private ITNfcRecordService tNfcRecordService;
    @Autowired
    private TokenService tokenService;

    /**
     * 查询nfc巡检记录id列表
     */
    //@PreAuthorize("@ss.hasPermi('system:record:list')")
    @GetMapping("/list")
    public TableDataInfo list(TNfcRecord tNfcRecord)
    {
        startPage();
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        SysUser user = loginUser.getUser();
        tNfcRecord.setCreateUser(user.getUserId());
        List<TNfcRecord> list = tNfcRecordService.selectTNfcRecordList(tNfcRecord);
        return getDataTable(list);
    }

    /**
     * 导出nfc巡检记录id列表
     */
    //@PreAuthorize("@ss.hasPermi('system:record:export')")
    @Log(title = "nfc巡检记录id", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TNfcRecord tNfcRecord)
    {
        List<TNfcRecord> list = tNfcRecordService.selectTNfcRecordList(tNfcRecord);
        ExcelUtil<TNfcRecord> util = new ExcelUtil<TNfcRecord>(TNfcRecord.class);
        return util.exportExcel(list, "nfc巡检记录id数据");
    }

    /**
     * 获取nfc巡检记录id详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:record:query')")
    @GetMapping(value = "/{recordId}")
    public AjaxResult getInfo(@PathVariable("recordId") Long recordId)
    {
        return AjaxResult.success(tNfcRecordService.selectTNfcRecordById(recordId));
    }

    /**
     * 新增nfc巡检记录id
     */
    //@PreAuthorize("@ss.hasPermi('system:record:add')")
    @Log(title = "nfc巡检记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TNfcRecord tNfcRecord)
    {
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        SysUser user = loginUser.getUser();
        tNfcRecord.setCreateUser(user.getUserId());
        return toAjax(tNfcRecordService.insertTNfcRecord(tNfcRecord));
    }

    /**
     * 修改nfc巡检记录id
     */
    //@PreAuthorize("@ss.hasPermi('system:record:edit')")
    @Log(title = "nfc巡检记录id", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TNfcRecord tNfcRecord)
    {
        return toAjax(tNfcRecordService.updateTNfcRecord(tNfcRecord));
    }

    /**
     * 删除nfc巡检记录id
     */
    //@PreAuthorize("@ss.hasPermi('system:record:remove')")
    @Log(title = "nfc巡检记录id", businessType = BusinessType.DELETE)
	@DeleteMapping("/{recordIds}")
    public AjaxResult remove(@PathVariable Long[] recordIds)
    {
        return toAjax(tNfcRecordService.deleteTNfcRecordByIds(recordIds));
    }
}
