package com.zehong.web.controller.system;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TDeviceAlarmInfo;
import com.zehong.system.service.ITDeviceAlarmInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 报警记录Controller
 * 
 * @author zehong
 * @date 2022-07-04
 */
@RestController
@RequestMapping("/system/alarm")
public class TDeviceAlarmInfoController extends BaseController
{
    @Autowired
    private ITDeviceAlarmInfoService tDeviceAlarmInfoService;

    /**
     * 查询报警记录列表
     */
    //@PreAuthorize("@ss.hasPermi('system:alarm:list')")
    @GetMapping("/list")
    public TableDataInfo list(TDeviceAlarmInfo tDeviceAlarmInfo)
    {
        startPage();
        List<TDeviceAlarmInfo> list = tDeviceAlarmInfoService.selectTDeviceAlarmInfoList(tDeviceAlarmInfo);
        return getDataTable(list);
    }

    /**
     * 系统数据
     * @param
     * @return
     */
    @GetMapping("/statistics")
    public AjaxResult selectStatistics()
    {
        return AjaxResult.success(tDeviceAlarmInfoService.selectStatistics());
    }

    /**
     * 导出报警记录列表
     */
    //@PreAuthorize("@ss.hasPermi('system:alarm:export')")
    @Log(title = "报警记录", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TDeviceAlarmInfo tDeviceAlarmInfo)
    {
        List<TDeviceAlarmInfo> list = tDeviceAlarmInfoService.selectTDeviceAlarmInfoList(tDeviceAlarmInfo);
        ExcelUtil<TDeviceAlarmInfo> util = new ExcelUtil<TDeviceAlarmInfo>(TDeviceAlarmInfo.class);
        return util.exportExcel(list, "报警记录数据");
    }

    /**
     * 获取报警记录详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:alarm:query')")
    @GetMapping(value = "/{alarmId}")
    public AjaxResult getInfo(@PathVariable("alarmId") Long alarmId)
    {
        return AjaxResult.success(tDeviceAlarmInfoService.selectTDeviceAlarmInfoById(alarmId));
    }

    /**
     * 新增报警记录
     */
    //@PreAuthorize("@ss.hasPermi('system:alarm:add')")
    @Log(title = "报警记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TDeviceAlarmInfo tDeviceAlarmInfo)
    {
        return toAjax(tDeviceAlarmInfoService.insertTDeviceAlarmInfo(tDeviceAlarmInfo));
    }

    /**
     * 修改报警记录
     */
    //@PreAuthorize("@ss.hasPermi('system:alarm:edit')")
    @Log(title = "报警记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TDeviceAlarmInfo tDeviceAlarmInfo)
    {
        return toAjax(tDeviceAlarmInfoService.updateTDeviceAlarmInfo(tDeviceAlarmInfo));
    }

    /**
     * 删除报警记录
     */
    //@PreAuthorize("@ss.hasPermi('system:alarm:remove')")
    @Log(title = "报警记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{alarmIds}")
    public AjaxResult remove(@PathVariable Long[] alarmIds)
    {
        return toAjax(tDeviceAlarmInfoService.deleteTDeviceAlarmInfoByIds(alarmIds));
    }

    @GetMapping("/sumAlarmTotal")
    public AjaxResult sumAlarmTotal(){
        return AjaxResult.success(tDeviceAlarmInfoService.sumAlarmTotal());
    }
}
