package com.zehong.web.controller.system;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TContractorTrainResultDetail;
import com.zehong.system.service.ITContractorTrainResultDetailService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 承包商及访客培训考试结果详情Controller
 *
 * @author wu
 * @date 2022-12-30
 */
@RestController
@RequestMapping("/system/detail")
public class TContractorTrainResultDetailController extends BaseController
{
    @Autowired
    private ITContractorTrainResultDetailService tContractorTrainResultDetailService;

    /**
     * 查询承包商及访客培训考试结果详情列表
     */
    //@PreAuthorize("@ss.hasPermi('system:detail:list')")
    @GetMapping("/list")
    public TableDataInfo list(TContractorTrainResultDetail tContractorTrainResultDetail)
    {
        startPage();
        List<TContractorTrainResultDetail> list = tContractorTrainResultDetailService.selectTContractorTrainResultDetailList(tContractorTrainResultDetail);
        return getDataTable(list);
    }

    /**
     * 导出承包商及访客培训考试结果详情列表
     */
    //@PreAuthorize("@ss.hasPermi('system:detail:export')")
    @Log(title = "承包商及访客培训考试结果详情", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TContractorTrainResultDetail tContractorTrainResultDetail)
    {
        List<TContractorTrainResultDetail> list = tContractorTrainResultDetailService.selectTContractorTrainResultDetailList(tContractorTrainResultDetail);
        ExcelUtil<TContractorTrainResultDetail> util = new ExcelUtil<TContractorTrainResultDetail>(TContractorTrainResultDetail.class);
        return util.exportExcel(list, "承包商及访客培训考试结果详情数据");
    }

    /**
     * 获取承包商及访客培训考试结果详情详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:detail:query')")
    @GetMapping(value = "/{detailId}")
    public AjaxResult getInfo(@PathVariable("detailId") Long detailId)
    {
        return AjaxResult.success(tContractorTrainResultDetailService.selectTContractorTrainResultDetailById(detailId));
    }

    /**
     * 新增承包商及访客培训考试结果详情
     */
    //@PreAuthorize("@ss.hasPermi('system:detail:add')")
    @Log(title = "承包商及访客培训考试结果详情", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TContractorTrainResultDetail tContractorTrainResultDetail)
    {
        return toAjax(tContractorTrainResultDetailService.insertTContractorTrainResultDetail(tContractorTrainResultDetail));
    }

    /**
     * 修改承包商及访客培训考试结果详情
     */
    //@PreAuthorize("@ss.hasPermi('system:detail:edit')")
    @Log(title = "承包商及访客培训考试结果详情", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TContractorTrainResultDetail tContractorTrainResultDetail)
    {
        return toAjax(tContractorTrainResultDetailService.updateTContractorTrainResultDetail(tContractorTrainResultDetail));
    }

    /**
     * 删除承包商及访客培训考试结果详情
     */
    //@PreAuthorize("@ss.hasPermi('system:detail:remove')")
    @Log(title = "承包商及访客培训考试结果详情", businessType = BusinessType.DELETE)
	@DeleteMapping("/{detailIds}")
    public AjaxResult remove(@PathVariable Long[] detailIds)
    {
        return toAjax(tContractorTrainResultDetailService.deleteTContractorTrainResultDetailByIds(detailIds));
    }
}
