package com.zehong.web.controller.system;

import java.util.Date;
import java.util.List;
import java.util.Map;

import io.swagger.annotations.ApiOperation;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TContractorTrainResult;
import com.zehong.system.service.ITContractorTrainResultService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 承包商及访客培训考试结果详情Controller
 *
 * @author zehong
 * @date 2022-12-27
 */
@RestController
@RequestMapping("/system/result")
public class TContractorTrainResultController extends BaseController
{
    @Autowired
    private ITContractorTrainResultService tContractorTrainResultService;

    /**
     * 查询承包商及访客培训考试结果详情列表
     */
    //@PreAuthorize("@ss.hasPermi('system:result:list')")
    @GetMapping("/list")
    public TableDataInfo list(TContractorTrainResult tContractorTrainResult)
    {
        startPage();
        List<TContractorTrainResult> list = tContractorTrainResultService.selectTContractorTrainResultList(tContractorTrainResult);
        return getDataTable(list);
    }


    /**
     * 导出承包商及访客培训考试结果详情列表
     */
    //@PreAuthorize("@ss.hasPermi('system:result:export')")
    @Log(title = "承包商及访客培训考试结果详情", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TContractorTrainResult tContractorTrainResult)
    {
        List<TContractorTrainResult> list = tContractorTrainResultService.selectTContractorTrainResultList(tContractorTrainResult);
        ExcelUtil<TContractorTrainResult> util = new ExcelUtil<TContractorTrainResult>(TContractorTrainResult.class);
        return util.exportExcel(list, "承包商及访客培训考试结果详情数据");
    }

    /**
     * 获取承包商及访客培训考试结果详情详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:result:query')")
    @GetMapping(value = "/{resultId}")
    public AjaxResult getInfo(@PathVariable("resultId") Long resultId)
    {
        return AjaxResult.success(tContractorTrainResultService.selectTContractorTrainResultById(resultId));
    }

    /**
     * 新增承包商及访客培训考试结果详情
     */
    //@PreAuthorize("@ss.hasPermi('system:result:add')")
    @Log(title = "承包商及访客培训考试结果详情", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TContractorTrainResult tContractorTrainResult)
    {
        return toAjax(tContractorTrainResultService.insertTContractorTrainResult(tContractorTrainResult));
    }

    @ApiOperation("用户课程考试交卷")
    @GetMapping("/examination")
    public AjaxResult examination( TContractorTrainResult tContractorTrainResult){

        //结束时间
        tContractorTrainResult.setTestEndTime(new Date());
        Map<String, Object> examination = tContractorTrainResultService.examination(tContractorTrainResult);
        return AjaxResult.success(examination);
    }

    /**
     * 修改承包商及访客培训考试结果详情
     */
    //@PreAuthorize("@ss.hasPermi('system:result:edit')")
    @Log(title = "承包商及访客培训考试结果详情", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TContractorTrainResult tContractorTrainResult)
    {
        return toAjax(tContractorTrainResultService.updateTContractorTrainResult(tContractorTrainResult));
    }

    /**
     * 删除承包商及访客培训考试结果详情
     */
    //@PreAuthorize("@ss.hasPermi('system:result:remove')")
    @Log(title = "承包商及访客培训考试结果详情", businessType = BusinessType.DELETE)
	@DeleteMapping("/{resultIds}")
    public AjaxResult remove(@PathVariable Long[] resultIds)
    {
        return toAjax(tContractorTrainResultService.deleteTContractorTrainResultByIds(resultIds));
    }
}
