package com.zehong.web.controller.safetyManagement;

import java.util.List;
import java.util.stream.Collectors;

import com.zehong.common.constant.UserConstants;
import com.zehong.common.core.domain.entity.SysRole;
import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.common.utils.StringUtils;
import com.zehong.system.domain.form.TStaffForm;
import com.zehong.system.domain.vo.TStaffVo;
import com.zehong.system.service.ISysPostService;
import com.zehong.system.service.ISysRoleService;
import com.zehong.system.service.ISysUserService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TStaff;
import com.zehong.system.service.ITStaffService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 员工信息管理Controller
 *
 * @author zehong
 * @date 2022-06-17
 */
@RestController
@RequestMapping("/safetyManagement/staff")
public class TStaffController extends BaseController
{
    @Autowired
    private ITStaffService tStaffService;

    @Autowired
    private ISysRoleService roleService;

    @Autowired
    private ISysPostService postService;

    @Autowired
    private ISysUserService userService;

    /**
     * 查询员工信息管理列表
     */
    //@PreAuthorize("@ss.hasPermi('safetyManagement:staff:list')")
    @GetMapping("/list")
    public TableDataInfo list(TStaffForm tStaff)
    {
        startPage();
        List<TStaffVo> list = tStaffService.selectTStaffList(tStaff);
        return getDataTable(list);
    }

    /**
     * 无分页查询
     * @param tStaff
     * @return
     */
    @GetMapping("/TStaffList")
    public TableDataInfo TStaffList(TStaffForm tStaff)
    {
        List<TStaffVo> list = tStaffService.selectTStaffList(tStaff);
        return getDataTable(list);
    }

    /**
     * 导出员工信息管理列表
     */
    @Log(title = "员工信息管理", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TStaffForm tStaff)
    {
        List<TStaffVo> list = tStaffService.selectTStaffList(tStaff);
        ExcelUtil<TStaffVo> util = new ExcelUtil<TStaffVo>(TStaffVo.class);
        return util.exportExcel(list, "员工信息管理数据");
    }

    /**
     * 获取员工信息管理详细信息
     */
    @GetMapping(value = {"/", "/{staffId}"})
    public AjaxResult getInfo(@PathVariable(value = "staffId", required = false) Long staffId)
    {
        AjaxResult ajax = AjaxResult.success();
        ajax.put("roles", roleService.selectRoleAll());
        ajax.put("posts", postService.selectPostAll());
        ajax.put("data", tStaffService.selectTStaffById(staffId));
        return ajax;
    }

    /**
     * 新增员工信息管理
     */
    @Log(title = "员工信息管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TStaff tStaff)
    {
        SysUser user=new SysUser();
        user.setPhonenumber(tStaff.getPhonenumber());
        if (UserConstants.NOT_UNIQUE.equals(userService.checkUserNameUnique(tStaff.getUserName()))) {
            return AjaxResult.error("新增用户'" + tStaff.getUserName() + "'失败，登录账号已存在");
        } else if (StringUtils.isNotEmpty(tStaff.getPhonenumber())
                && UserConstants.NOT_UNIQUE.equals(userService.checkPhoneUnique(user))) {
            return AjaxResult.error("新增用户'" + tStaff.getUserName() + "'失败，手机号码已存在");
        }
        //密码加密
        tStaff.setPassword(SecurityUtils.encryptPassword(tStaff.getPassword()));
        return toAjax(tStaffService.insertTStaff(tStaff));
    }

    /**
     * 修改员工信息管理
     */
    @Log(title = "员工信息管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TStaff tStaff)
    {
        return toAjax(tStaffService.updateTStaff(tStaff));
    }

    /**
     * 删除员工信息管理
     */
    @Log(title = "员工信息管理", businessType = BusinessType.DELETE)
	@DeleteMapping("/{staffIds}")
    public AjaxResult remove(@PathVariable Long[] staffIds)
    {
        return toAjax(tStaffService.deleteTStaffByIds(staffIds));
    }
}
