package com.zehong.web.controller.safetyManagement;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TSafetyCommitmentAnnouncement;
import com.zehong.system.service.ITSafetyCommitmentAnnouncementService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 安全承诺公告Controller
 * 
 * @author zehong
 * @date 2022-12-21
 */
@RestController
@RequestMapping("/safetyManagement/announcement")
public class TSafetyCommitmentAnnouncementController extends BaseController
{
    @Autowired
    private ITSafetyCommitmentAnnouncementService tSafetyCommitmentAnnouncementService;

    /**
     * 查询安全承诺公告列表
     */
    @PreAuthorize("@ss.hasPermi('system:announcement:list')")
    @GetMapping("/list")
    public TableDataInfo list(TSafetyCommitmentAnnouncement tSafetyCommitmentAnnouncement)
    {
        startPage();
        List<TSafetyCommitmentAnnouncement> list = tSafetyCommitmentAnnouncementService.selectTSafetyCommitmentAnnouncementList(tSafetyCommitmentAnnouncement);
        return getDataTable(list);
    }

    /**
     * 新增安全承诺公告验证
     */
    @GetMapping("/getCurrent")
    public AjaxResult getCurrent(TSafetyCommitmentAnnouncement tSafetyCommitmentAnnouncement)
    {
        Calendar calender = Calendar.getInstance();
        calender.setTime(new Date());
        String endTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(calender.getTime());

        calender.set(Calendar.HOUR_OF_DAY, 0);
        calender.set(Calendar.MINUTE, 0);
        calender.set(Calendar.SECOND, 0);
        String beginTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(calender.getTime());

        Map<String, Object> map = new HashMap<>();
        map.put("beginTime", beginTime);
        map.put("endTime", endTime);
        tSafetyCommitmentAnnouncement.setParams(map);
        List<TSafetyCommitmentAnnouncement> list = tSafetyCommitmentAnnouncementService.selectTSafetyCommitmentAnnouncementList(tSafetyCommitmentAnnouncement);
        return AjaxResult.success(list);
    }

    /**
     * 导出安全承诺公告列表
     */
    //@PreAuthorize("@ss.hasPermi('system:announcement:export')")
    @Log(title = "安全承诺公告", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TSafetyCommitmentAnnouncement tSafetyCommitmentAnnouncement)
    {
        List<TSafetyCommitmentAnnouncement> list = tSafetyCommitmentAnnouncementService.selectTSafetyCommitmentAnnouncementList(tSafetyCommitmentAnnouncement);
        ExcelUtil<TSafetyCommitmentAnnouncement> util = new ExcelUtil<TSafetyCommitmentAnnouncement>(TSafetyCommitmentAnnouncement.class);
        return util.exportExcel(list, "安全承诺公告数据");
    }

    /**
     * 获取安全承诺公告详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:announcement:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tSafetyCommitmentAnnouncementService.selectTSafetyCommitmentAnnouncementById(id));
    }

    /**
     * 新增安全承诺公告
     */
    //@PreAuthorize("@ss.hasPermi('system:announcement:add')")
    @Log(title = "安全承诺公告", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TSafetyCommitmentAnnouncement tSafetyCommitmentAnnouncement)
    {
        return toAjax(tSafetyCommitmentAnnouncementService.insertTSafetyCommitmentAnnouncement(tSafetyCommitmentAnnouncement));
    }

    /**
     * 修改安全承诺公告
     */
    //@PreAuthorize("@ss.hasPermi('system:announcement:edit')")
    @Log(title = "安全承诺公告", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TSafetyCommitmentAnnouncement tSafetyCommitmentAnnouncement)
    {
        return toAjax(tSafetyCommitmentAnnouncementService.updateTSafetyCommitmentAnnouncement(tSafetyCommitmentAnnouncement));
    }

    /**
     * 删除安全承诺公告
     */
    //@PreAuthorize("@ss.hasPermi('system:announcement:remove')")
    @Log(title = "安全承诺公告", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tSafetyCommitmentAnnouncementService.deleteTSafetyCommitmentAnnouncementByIds(ids));
    }
}
