package com.zehong.web.controller.safetyManagement;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TEnterpriseCertificate;
import com.zehong.system.service.ITEnterpriseCertificateService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 企业资质证照管理Controller
 * 
 * @author zehong
 * @date 2022-06-23
 */
@RestController
@RequestMapping("/safetyManagement/enterpriseCertificate")
public class TEnterpriseCertificateController extends BaseController
{
    @Autowired
    private ITEnterpriseCertificateService tEnterpriseCertificateService;

    /**
     * 查询企业资质证照管理列表
     */
    //@PreAuthorize("@ss.hasPermi('safetyManagement:enterpriseCertificate:list')")
    @GetMapping("/list")
    public TableDataInfo list(TEnterpriseCertificate tEnterpriseCertificate)
    {
        startPage();
        List<TEnterpriseCertificate> list = tEnterpriseCertificateService.selectTEnterpriseCertificateList(tEnterpriseCertificate);
        return getDataTable(list);
    }

    /**
     * 导出企业资质证照管理列表
     */
    @Log(title = "企业资质证照管理", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TEnterpriseCertificate tEnterpriseCertificate)
    {
        List<TEnterpriseCertificate> list = tEnterpriseCertificateService.selectTEnterpriseCertificateList(tEnterpriseCertificate);
        ExcelUtil<TEnterpriseCertificate> util = new ExcelUtil<TEnterpriseCertificate>(TEnterpriseCertificate.class);
        return util.exportExcel(list, "企业资质证照管理数据");
    }

    /**
     * 获取企业资质证照管理详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tEnterpriseCertificateService.selectTEnterpriseCertificateById(id));
    }

    /**
     * 新增企业资质证照管理
     */
    @Log(title = "企业资质证照管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TEnterpriseCertificate tEnterpriseCertificate)
    {
        return toAjax(tEnterpriseCertificateService.insertTEnterpriseCertificate(tEnterpriseCertificate));
    }

    /**
     * 修改企业资质证照管理
     */
    @Log(title = "企业资质证照管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TEnterpriseCertificate tEnterpriseCertificate)
    {
        return toAjax(tEnterpriseCertificateService.updateTEnterpriseCertificate(tEnterpriseCertificate));
    }

    /**
     * 删除企业资质证照管理
     */
    @Log(title = "企业资质证照管理", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tEnterpriseCertificateService.deleteTEnterpriseCertificateByIds(ids));
    }
}
