package com.zehong.web.controller.riskManager;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TRiskManager;
import com.zehong.system.service.ITRiskManagerService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 【请填写功能名称】Controller
 * 
 * @author zehong
 * @date 2022-07-01
 */
@RestController
@RequestMapping("/system/riskManager")
public class TRiskManagerController extends BaseController
{
    @Autowired
    private ITRiskManagerService tRiskManagerService;

    /**
     * 查询【请填写功能名称】列表
     */
//    //@PreAuthorize("@ss.hasPermi('system:manager:list')")
    @GetMapping("/list")
    public TableDataInfo list(TRiskManager tRiskManager)
    {
        startPage();
        List<TRiskManager> list = tRiskManagerService.selectTRiskManagerList(tRiskManager);
        return getDataTable(list);
    }

    /**
     * 导出【请填写功能名称】列表
     */
//    //@PreAuthorize("@ss.hasPermi('system:manager:export')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TRiskManager tRiskManager)
    {
        List<TRiskManager> list = tRiskManagerService.selectTRiskManagerList(tRiskManager);
        ExcelUtil<TRiskManager> util = new ExcelUtil<TRiskManager>(TRiskManager.class);
        return util.exportExcel(list, "【请填写功能名称】数据");
    }

    /**
     * 获取【请填写功能名称】详细信息
     */
    // //@PreAuthorize("@ss.hasPermi('system:manager:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tRiskManagerService.selectTRiskManagerById(id));
    }

    /**
     * 新增【请填写功能名称】
     */
    // //@PreAuthorize("@ss.hasPermi('system:manager:add')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TRiskManager tRiskManager)
    {
        return toAjax(tRiskManagerService.insertTRiskManager(tRiskManager));
    }

    /**
     * 修改【请填写功能名称】
     */
    // //@PreAuthorize("@ss.hasPermi('system:manager:edit')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TRiskManager tRiskManager)
    {
        return toAjax(tRiskManagerService.updateTRiskManager(tRiskManager));
    }

    /**
     * 删除【请填写功能名称】
     */
    // //@PreAuthorize("@ss.hasPermi('system:manager:remove')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tRiskManagerService.deleteTRiskManagerByIds(ids));
    }
}
