package com.zehong.web.controller.resources;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.ServletUtils;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.framework.web.service.TokenService;
import com.zehong.system.domain.TPlanInfo;
import com.zehong.system.service.ITPlanInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 预案管理Controller
 * 
 * @author zehong
 * @date 2022-06-01
 */
@RestController
@RequestMapping("/system/reservePlan")
public class TPlanInfoController extends BaseController
{
    @Autowired
    private ITPlanInfoService tPlanInfoService;
    @Autowired
    private TokenService tokenService;

    /**
     * 查询预案管理列表
     */
    //@PreAuthorize("@ss.hasPermi('plan:reservePlan:list')")
    @GetMapping("/list")
    public TableDataInfo list(TPlanInfo tPlanInfo)
    {
        startPage();
        List<TPlanInfo> list = tPlanInfoService.selectTPlanInfoList(tPlanInfo);
        return getDataTable(list);
    }

    /**
     * 导出预案管理列表
     */
    //@PreAuthorize("@ss.hasPermi('plan:reservePlan:export')")
    @Log(title = "应急处置方案", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TPlanInfo tPlanInfo)
    {
        List<TPlanInfo> list = tPlanInfoService.selectTPlanInfoList(tPlanInfo);
        ExcelUtil<TPlanInfo> util = new ExcelUtil<TPlanInfo>(TPlanInfo.class);
        return util.exportExcel(list, "应急处置方案数据");
    }

    /**
     * 获取预案管理详细信息
     */
    //@PreAuthorize("@ss.hasPermi('plan:reservePlan:query')")
    @GetMapping(value = "/{planId}")
    public AjaxResult getInfo(@PathVariable("planId") Long planId)
    {
        return AjaxResult.success(tPlanInfoService.selectTPlanInfoById(planId));
    }

    /**
     * 新增预案管理
     */
    //@PreAuthorize("@ss.hasPermi('plan:reservePlan:add')")
    @Log(title = "应急处置方案", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TPlanInfo tPlanInfo)
    {
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        tPlanInfo.setCreateBy(loginUser.getUsername());
        return toAjax(tPlanInfoService.insertTPlanInfo(tPlanInfo));
    }

    /**
     * 修改预案管理
     */
    //@PreAuthorize("@ss.hasPermi('plan:reservePlan:edit')")
    @Log(title = "应急处置方案", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TPlanInfo tPlanInfo)
    {
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        tPlanInfo.setUpdateBy(loginUser.getUsername());
        return toAjax(tPlanInfoService.updateTPlanInfo(tPlanInfo));
    }

    /**
     * 删除预案管理
     */
    //@PreAuthorize("@ss.hasPermi('plan:reservePlan:remove')")
    @Log(title = "应急处置方案", businessType = BusinessType.DELETE)
	@DeleteMapping("/{planIds}")
    public AjaxResult remove(@PathVariable Long[] planIds)
    {
        return toAjax(tPlanInfoService.deleteTPlanInfoByIds(planIds));
    }
}
