package com.zehong.web.controller.resources;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TMaterialInfo;
import com.zehong.system.service.ITMaterialInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 应急物资管理Controller
 * 
 * @author zehong
 * @date 2022-07-01
 */
@RestController
@RequestMapping("/system/info")
public class TMaterialInfoController extends BaseController
{
    @Autowired
    private ITMaterialInfoService tMaterialInfoService;

    /**
     * 查询应急物资管理列表
     */
    //@PreAuthorize("@ss.hasPermi('system:info:list')")
    @GetMapping("/list")
    public TableDataInfo list(TMaterialInfo tMaterialInfo)
    {
        startPage();
        List<TMaterialInfo> list = tMaterialInfoService.selectTMaterialInfoList(tMaterialInfo);
        return getDataTable(list);
    }

    /**
     * 导出应急物资管理列表
     */
    //@PreAuthorize("@ss.hasPermi('system:info:export')")
    @Log(title = "应急物资管理", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TMaterialInfo tMaterialInfo)
    {
        List<TMaterialInfo> list = tMaterialInfoService.selectTMaterialInfoList(tMaterialInfo);
        ExcelUtil<TMaterialInfo> util = new ExcelUtil<TMaterialInfo>(TMaterialInfo.class);
        return util.exportExcel(list, "应急物资管理数据");
    }

    /**
     * 获取应急物资管理详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:info:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tMaterialInfoService.selectTMaterialInfoById(id));
    }

    /**
     * 新增应急物资管理
     */
    //@PreAuthorize("@ss.hasPermi('system:info:add')")
    @Log(title = "应急物资管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TMaterialInfo tMaterialInfo)
    {
        return toAjax(tMaterialInfoService.insertTMaterialInfo(tMaterialInfo));
    }

    /**
     * 修改应急物资管理
     */
    //@PreAuthorize("@ss.hasPermi('system:info:edit')")
    @Log(title = "应急物资管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TMaterialInfo tMaterialInfo)
    {
        return toAjax(tMaterialInfoService.updateTMaterialInfo(tMaterialInfo));
    }

    /**
     * 删除应急物资管理
     */
    //@PreAuthorize("@ss.hasPermi('system:info:remove')")
    @Log(title = "应急物资管理", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tMaterialInfoService.deleteTMaterialInfoByIds(ids));
    }
}
