package com.zehong.web.controller.patrol;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TPatrolPosition;
import com.zehong.system.service.ITPatrolPositionService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 巡检点Controller
 * 
 * @author zehong
 * @date 2022-06-17
 */
@RestController
@RequestMapping("/system/position")
public class TPatrolPositionController extends BaseController
{
    @Autowired
    private ITPatrolPositionService tPatrolPositionService;

    /**
     * 查询巡检点列表
     */
    //@PreAuthorize("@ss.hasPermi('system:position:list')")
    @GetMapping("/list")
    public TableDataInfo list(TPatrolPosition tPatrolPosition)
    {
        startPage();
        List<TPatrolPosition> list = tPatrolPositionService.selectTPatrolPositionList(tPatrolPosition);
        return getDataTable(list);
    }

    /**
     * 导出巡检点列表
     */
    //@PreAuthorize("@ss.hasPermi('system:position:export')")
    @Log(title = "巡检点", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TPatrolPosition tPatrolPosition)
    {
        List<TPatrolPosition> list = tPatrolPositionService.selectTPatrolPositionList(tPatrolPosition);
        ExcelUtil<TPatrolPosition> util = new ExcelUtil<TPatrolPosition>(TPatrolPosition.class);
        return util.exportExcel(list, "巡检点数据");
    }

    /**
     * 获取巡检点详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:position:query')")
    @GetMapping(value = "/{patrolId}")
    public AjaxResult getInfo(@PathVariable("patrolId") Long patrolId)
    {
        return AjaxResult.success(tPatrolPositionService.selectTPatrolPositionById(patrolId));
    }

    /**
     * 巡检点树
     */
    @GetMapping(value = "/treeDetail")
    public AjaxResult getInfo()
    {
        return AjaxResult.success(tPatrolPositionService.selectTPatrolPositionTree());
    }
    /**
     * 新增巡检点
     */
    //@PreAuthorize("@ss.hasPermi('system:position:add')")
    @Log(title = "巡检点", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TPatrolPosition tPatrolPosition)
    {
        return toAjax(tPatrolPositionService.insertTPatrolPosition(tPatrolPosition));
    }

    /**
     * 修改巡检点
     */
    //@PreAuthorize("@ss.hasPermi('system:position:edit')")
    @Log(title = "巡检点", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TPatrolPosition tPatrolPosition)
    {
        return toAjax(tPatrolPositionService.updateTPatrolPosition(tPatrolPosition));
    }

    /**
     * 删除巡检点
     */
    //@PreAuthorize("@ss.hasPermi('system:position:remove')")
    @Log(title = "巡检点", businessType = BusinessType.DELETE)
	@DeleteMapping("/{patrolIds}")
    public AjaxResult remove(@PathVariable Long[] patrolIds)
    {
        return toAjax(tPatrolPositionService.deleteTPatrolPositionByIds(patrolIds));
    }
}
