package com.zehong.web.controller.map;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TMapDeviceMonitor;
import com.zehong.system.service.ITMapDeviceMonitorService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 上图设备监测Controller
 * 
 * @author zehong
 * @date 2022-10-08
 */
@RestController
@RequestMapping("/map/monitor")
public class TMapDeviceMonitorController extends BaseController
{
    @Autowired
    private ITMapDeviceMonitorService tMapDeviceMonitorService;

    /**
     * 查询上图设备监测列表
     */
    @PreAuthorize("@ss.hasPermi('system:monitor:list')")
    @GetMapping("/list")
    public TableDataInfo list(TMapDeviceMonitor tMapDeviceMonitor)
    {
        startPage();
        List<TMapDeviceMonitor> list = tMapDeviceMonitorService.selectTMapDeviceMonitorList(tMapDeviceMonitor);
        return getDataTable(list);
    }

    /**
     * 导出上图设备监测列表
     */
    @PreAuthorize("@ss.hasPermi('system:monitor:export')")
    @Log(title = "上图设备监测", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TMapDeviceMonitor tMapDeviceMonitor)
    {
        List<TMapDeviceMonitor> list = tMapDeviceMonitorService.selectTMapDeviceMonitorList(tMapDeviceMonitor);
        ExcelUtil<TMapDeviceMonitor> util = new ExcelUtil<TMapDeviceMonitor>(TMapDeviceMonitor.class);
        return util.exportExcel(list, "上图设备监测数据");
    }

    /**
     * 获取上图设备监测详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:monitor:query')")
    @GetMapping(value = "/{monitorId}")
    public AjaxResult getInfo(@PathVariable("monitorId") Long monitorId)
    {
        return AjaxResult.success(tMapDeviceMonitorService.selectTMapDeviceMonitorById(monitorId));
    }

    /**
     * 新增上图设备监测
     */
    @PreAuthorize("@ss.hasPermi('system:monitor:add')")
    @Log(title = "上图设备监测", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TMapDeviceMonitor tMapDeviceMonitor)
    {
        return toAjax(tMapDeviceMonitorService.insertTMapDeviceMonitor(tMapDeviceMonitor));
    }

    /**
     * 修改上图设备监测
     */
    @PreAuthorize("@ss.hasPermi('system:monitor:edit')")
    @Log(title = "上图设备监测", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TMapDeviceMonitor tMapDeviceMonitor)
    {
        return toAjax(tMapDeviceMonitorService.updateTMapDeviceMonitor(tMapDeviceMonitor));
    }

    /**
     * 删除上图设备监测
     */
    @PreAuthorize("@ss.hasPermi('system:monitor:remove')")
    @Log(title = "上图设备监测", businessType = BusinessType.DELETE)
	@DeleteMapping("/{monitorIds}")
    public AjaxResult remove(@PathVariable Long[] monitorIds)
    {
        return toAjax(tMapDeviceMonitorService.deleteTMapDeviceMonitorByIds(monitorIds));
    }
}
