package com.zehong.web.controller.map;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TMapDeviceInfo;
import com.zehong.system.service.ITMapDeviceInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 上图设备信息Controller
 * 
 * @author zehong
 * @date 2022-10-08
 */
@RestController
@RequestMapping("/map/deviceInfo")
public class TMapDeviceInfoController extends BaseController
{
    @Autowired
    private ITMapDeviceInfoService tMapDeviceInfoService;

    /**
     * 查询上图设备信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TMapDeviceInfo tMapDeviceInfo)
    {
        startPage();
        List<TMapDeviceInfo> list = tMapDeviceInfoService.selectTMapDeviceInfoList(tMapDeviceInfo);
        return getDataTable(list);
    }

    /**
     * 获取所有上图设备信息
     * @param tMapDeviceInfo
     * @return
     */
    @GetMapping("/deviceInfoLists")
    public List<TMapDeviceInfo> deviceInfoLists(TMapDeviceInfo tMapDeviceInfo){
        return tMapDeviceInfoService.deviceInfoLists(tMapDeviceInfo);
    }

    /**
     * 导出上图设备信息列表
     */
    @Log(title = "上图设备信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TMapDeviceInfo tMapDeviceInfo)
    {
        List<TMapDeviceInfo> list = tMapDeviceInfoService.selectTMapDeviceInfoList(tMapDeviceInfo);
        ExcelUtil<TMapDeviceInfo> util = new ExcelUtil<TMapDeviceInfo>(TMapDeviceInfo.class);
        return util.exportExcel(list, "上图设备信息数据");
    }

    /**
     * 获取上图设备信息详细信息
     */
    @GetMapping(value = "/{mapDeviceId}")
    public AjaxResult getInfo(@PathVariable("mapDeviceId") Long mapDeviceId)
    {
        return AjaxResult.success(tMapDeviceInfoService.selectTMapDeviceInfoById(mapDeviceId));
    }

    /**
     * 新增上图设备信息
     */
    @Log(title = "上图设备信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TMapDeviceInfo tMapDeviceInfo)
    {
        return toAjax(tMapDeviceInfoService.insertTMapDeviceInfo(tMapDeviceInfo));
    }

    /**
     * 修改上图设备信息
     */
    @Log(title = "上图设备信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TMapDeviceInfo tMapDeviceInfo)
    {
        return toAjax(tMapDeviceInfoService.updateTMapDeviceInfo(tMapDeviceInfo));
    }

    /**
     * 删除上图设备信息
     */
    @Log(title = "上图设备信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{mapDeviceIds}")
    public AjaxResult remove(@PathVariable Long[] mapDeviceIds)
    {
        return toAjax(tMapDeviceInfoService.deleteTMapDeviceInfoByIds(mapDeviceIds));
    }
}
