package com.zehong.web.controller.hiddenDanger;

import java.util.List;

import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.utils.ServletUtils;
import com.zehong.framework.web.service.TokenService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TStaningBook;
import com.zehong.system.service.ITStaningBookService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 隐患台账Controller
 * 
 * @author zehong
 * @date 2022-07-09
 */
@RestController
@RequestMapping("/system/book")
public class TStaningBookController extends BaseController
{
    @Autowired
    private ITStaningBookService tStaningBookService;
    @Autowired
    private TokenService tokenService;
    /**
     * 查询隐患台账列表
     */
    //@PreAuthorize("@ss.hasPermi('system:book:list')")
    @GetMapping("/list")
    public TableDataInfo list(TStaningBook tStaningBook)
    {
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        SysUser user = loginUser.getUser();
        startPage();
        List<TStaningBook> list = tStaningBookService.selectTStaningBookList(tStaningBook,user.getDeptId());
        return getDataTable(list);
    }

    /**
     * 导出隐患台账列表
     */
    //@PreAuthorize("@ss.hasPermi('system:book:export')")
    @Log(title = "隐患台账", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TStaningBook tStaningBook)
    {
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        SysUser user = loginUser.getUser();
        startPage();
        List<TStaningBook> list = tStaningBookService.selectTStaningBookList(tStaningBook,user.getDeptId());
        ExcelUtil<TStaningBook> util = new ExcelUtil<TStaningBook>(TStaningBook.class);
        return util.exportExcel(list, "隐患台账数据");
    }

    /**
     * 获取隐患台账详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:book:query')")
    @GetMapping(value = "/{bookId}")
    public AjaxResult getInfo(@PathVariable("bookId") Long bookId)
    {
        return AjaxResult.success(tStaningBookService.selectTStaningBookById(bookId));
    }

    /**
     * 新增隐患台账
     */
    //@PreAuthorize("@ss.hasPermi('system:book:add')")
    @Log(title = "隐患台账", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TStaningBook tStaningBook)
    {
        return toAjax(tStaningBookService.insertTStaningBook(tStaningBook));
    }

    /**
     * 修改隐患台账
     */
    //@PreAuthorize("@ss.hasPermi('system:book:edit')")
    @Log(title = "隐患台账", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TStaningBook tStaningBook)
    {
        return toAjax(tStaningBookService.updateTStaningBook(tStaningBook));
    }

    /**
     * 删除隐患台账
     */
    //@PreAuthorize("@ss.hasPermi('system:book:remove')")
    @Log(title = "隐患台账", businessType = BusinessType.DELETE)
	@DeleteMapping("/{bookIds}")
    public AjaxResult remove(@PathVariable Long[] bookIds)
    {
        return toAjax(tStaningBookService.deleteTStaningBookByIds(bookIds));
    }

    /**
     * 统计，按年、月、日统计发现数量和已处置数量
     * 日，为当日；月为当前30日内；年为当前365日内
     * @return
     */
    @GetMapping(value = "/statics")
    public AjaxResult statics(String type){
        return AjaxResult.success(tStaningBookService.statics(type));
    }
}
