package com.zehong.web.controller.hiddenDanger;

import java.util.List;

import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.utils.ServletUtils;
import com.zehong.framework.web.service.SysLoginService;
import com.zehong.framework.web.service.TokenService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.THiddenTroubleWork;
import com.zehong.system.service.ITHiddenTroubleWorkService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 隐患排查任务Controller
 * 
 * @author zehong
 * @date 2022-07-11
 */
@RestController
@RequestMapping("/system/workCheck")
public class THiddenTroubleWorkController extends BaseController
{
    @Autowired
    private ITHiddenTroubleWorkService tHiddenTroubleWorkService;
    @Autowired
    private TokenService tokenService;

    /**
     * 查询隐患排查任务列表
     */
    //@PreAuthorize("@ss.hasPermi('system:workCheck:list')")
    @GetMapping("/list")
    public TableDataInfo list(THiddenTroubleWork tHiddenTroubleWork)
    {
        startPage();
        List<THiddenTroubleWork> list = tHiddenTroubleWorkService.selectTHiddenTroubleWorkList(tHiddenTroubleWork);
        return getDataTable(list);
    }
    @GetMapping("/listApp")
    public TableDataInfo listApp(THiddenTroubleWork tHiddenTroubleWork)
    {
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        SysUser user = loginUser.getUser();
        tHiddenTroubleWork.setStaffId(user.getUserId());
        startPage();
        List<THiddenTroubleWork> list = tHiddenTroubleWorkService.selectTHiddenTroubleWorkListApp(tHiddenTroubleWork);
        return getDataTable(list);
    }
    /**
     * 导出隐患排查任务列表
     */
    //@PreAuthorize("@ss.hasPermi('system:workCheck:export')")
    @Log(title = "隐患排查任务", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(THiddenTroubleWork tHiddenTroubleWork)
    {
        List<THiddenTroubleWork> list = tHiddenTroubleWorkService.selectTHiddenTroubleWorkList(tHiddenTroubleWork);
        ExcelUtil<THiddenTroubleWork> util = new ExcelUtil<THiddenTroubleWork>(THiddenTroubleWork.class);
        return util.exportExcel(list, "隐患排查任务数据");
    }

    /**
     * 获取隐患排查任务详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:workCheck:query')")
    @GetMapping(value = "/{workId}")
    public AjaxResult getInfo(@PathVariable("workId") Long workId)
    {
        return AjaxResult.success(tHiddenTroubleWorkService.selectTHiddenTroubleWorkById(workId));
    }

    /**
     * 新增隐患排查任务
     */
    //@PreAuthorize("@ss.hasPermi('system:workCheck:add')")
    @Log(title = "隐患排查任务", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody THiddenTroubleWork tHiddenTroubleWork)
    {
        int a = tHiddenTroubleWorkService.insertTHiddenTroubleWork(tHiddenTroubleWork);
        if(a==-2){
            return AjaxResult.error("任务进行中不可重复创建");
        }
        return toAjax(a);
    }

    /**
     * 修改隐患排查任务
     */
    //@PreAuthorize("@ss.hasPermi('system:workCheck:edit')")
    @Log(title = "隐患排查任务", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody THiddenTroubleWork tHiddenTroubleWork)
    {
        return toAjax(tHiddenTroubleWorkService.updateTHiddenTroubleWork(tHiddenTroubleWork));
    }

    /**
     * 删除隐患排查任务
     */
    //@PreAuthorize("@ss.hasPermi('system:workCheck:remove')")
    @Log(title = "隐患排查任务", businessType = BusinessType.DELETE)
	@DeleteMapping("/{workIds}")
    public AjaxResult remove(@PathVariable Long[] workIds)
    {
        return toAjax(tHiddenTroubleWorkService.deleteTHiddenTroubleWorkByIds(workIds));
    }
}
