package com.zehong.web.controller.hiddenDanger;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.THiddenLibrary;
import com.zehong.system.service.ITHiddenLibraryService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 隐患排查库Controller
 * 
 * @author zehong
 * @date 2022-07-13
 */
@RestController
@RequestMapping("/system/library")
public class THiddenLibraryController extends BaseController
{
    @Autowired
    private ITHiddenLibraryService tHiddenLibraryService;

    /**
     * 查询隐患排查库列表
     */
    //@PreAuthorize("@ss.hasPermi('system:library:list')")
    @GetMapping("/list")
    public TableDataInfo list(THiddenLibrary tHiddenLibrary)
    {
        startPage();
        List<THiddenLibrary> list = tHiddenLibraryService.selectTHiddenLibraryList(tHiddenLibrary);
        return getDataTable(list);
    }

    /**
     * 导出隐患排查库列表
     */
    //@PreAuthorize("@ss.hasPermi('system:library:export')")
    @Log(title = "隐患排查库", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(THiddenLibrary tHiddenLibrary)
    {
        List<THiddenLibrary> list = tHiddenLibraryService.selectTHiddenLibraryList(tHiddenLibrary);
        ExcelUtil<THiddenLibrary> util = new ExcelUtil<THiddenLibrary>(THiddenLibrary.class);
        return util.exportExcel(list, "隐患排查库数据");
    }

    /**
     * 获取隐患排查库详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:library:query')")
    @GetMapping(value = "/{libraryId}")
    public AjaxResult getInfo(@PathVariable("libraryId") Long libraryId)
    {
        return AjaxResult.success(tHiddenLibraryService.selectTHiddenLibraryById(libraryId));
    }

    /**
     * 新增隐患排查库
     */
    //@PreAuthorize("@ss.hasPermi('system:library:add')")
    @Log(title = "隐患排查库", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody THiddenLibrary tHiddenLibrary)
    {
        return toAjax(tHiddenLibraryService.insertTHiddenLibrary(tHiddenLibrary));
    }

    /**
     * 修改隐患排查库
     */
    //@PreAuthorize("@ss.hasPermi('system:library:edit')")
    @Log(title = "隐患排查库", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody THiddenLibrary tHiddenLibrary)
    {
        return toAjax(tHiddenLibraryService.updateTHiddenLibrary(tHiddenLibrary));
    }

    /**
     * 删除隐患排查库
     */
    //@PreAuthorize("@ss.hasPermi('system:library:remove')")
    @Log(title = "隐患排查库", businessType = BusinessType.DELETE)
	@DeleteMapping("/{libraryIds}")
    public AjaxResult remove(@PathVariable Long[] libraryIds)
    {
        return toAjax(tHiddenLibraryService.deleteTHiddenLibraryByIds(libraryIds));
    }
}
