package com.zehong.web.controller.entranceguard;

import java.util.List;
import java.util.Map;

import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TEntranceGuardPersonInfo;
import com.zehong.system.service.ITEntranceGuardPersonInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 门禁人员信息Controller
 * 
 * @author zehong
 * @date 2022-11-02
 */
@RestController
@RequestMapping("/entranceGuardPerson/info")
public class TEntranceGuardPersonInfoController extends BaseController
{
    @Autowired
    private ITEntranceGuardPersonInfoService tEntranceGuardPersonInfoService;

    /**
     * 查询门禁人员信息列表
     */
    //@PreAuthorize("@ss.hasPermi('system:info:list')")
    @GetMapping("/list")
    public TableDataInfo list(TEntranceGuardPersonInfo tEntranceGuardPersonInfo)
    {
        startPage();
        List<TEntranceGuardPersonInfo> list = tEntranceGuardPersonInfoService.selectTEntranceGuardPersonInfoList(tEntranceGuardPersonInfo);
        return getDataTable(list);
    }

    /**
     * 导出门禁人员信息列表
     */
    //@PreAuthorize("@ss.hasPermi('system:info:export')")
    @Log(title = "门禁人员信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TEntranceGuardPersonInfo tEntranceGuardPersonInfo)
    {
        List<TEntranceGuardPersonInfo> list = tEntranceGuardPersonInfoService.selectTEntranceGuardPersonInfoList(tEntranceGuardPersonInfo);
        ExcelUtil<TEntranceGuardPersonInfo> util = new ExcelUtil<TEntranceGuardPersonInfo>(TEntranceGuardPersonInfo.class);
        return util.exportExcel(list, "门禁人员信息数据");
    }

    /**
     * 获取门禁人员信息详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:info:query')")
    @GetMapping(value = "/{entranceGuardPersonId}")
    public AjaxResult getInfo(@PathVariable("entranceGuardPersonId") Long entranceGuardPersonId)
    {
        return AjaxResult.success(tEntranceGuardPersonInfoService.selectTEntranceGuardPersonInfoById(entranceGuardPersonId));
    }

    /**
     * 新增门禁人员信息
     */
    //@PreAuthorize("@ss.hasPermi('system:info:add')")
    @Log(title = "门禁人员信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TEntranceGuardPersonInfo tEntranceGuardPersonInfo)
    {
        return toAjax(tEntranceGuardPersonInfoService.insertTEntranceGuardPersonInfo(tEntranceGuardPersonInfo));
    }

    /**
     * 修改门禁人员信息
     */
    //@PreAuthorize("@ss.hasPermi('system:info:edit')")
    @Log(title = "门禁人员信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TEntranceGuardPersonInfo tEntranceGuardPersonInfo)
    {
        return toAjax(tEntranceGuardPersonInfoService.updateTEntranceGuardPersonInfo(tEntranceGuardPersonInfo));
    }

    /**
     * 删除门禁人员信息
     */
    //@PreAuthorize("@ss.hasPermi('system:info:remove')")
    @Log(title = "门禁人员信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{entranceGuardPersonIds}")
    public AjaxResult remove(@PathVariable Long[] entranceGuardPersonIds)
    {
        return toAjax(tEntranceGuardPersonInfoService.deleteTEntranceGuardPersonInfoByIds(entranceGuardPersonIds));
    }

    /**
     * 二道门人员信息初始化
     */
    @GetMapping("/getEntranceGuardPersonInfo")
    public AjaxResult getEntranceGuardPersonInfo(){
        return AjaxResult.success(tEntranceGuardPersonInfoService.getEntranceGuardPersonInfo());
    }
}
