package com.zehong.web.controller.deviceManagement;

import java.util.List;

import com.zehong.system.domain.vo.TSpecialDeviceRecordVo;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TSpecialDeviceRecord;
import com.zehong.system.service.ITSpecialDeviceRecordService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 特种设备台账Controller
 * 
 * @author zehong
 * @date 2022-07-02
 */
@RestController
@RequestMapping("/deviceManagement/specialDeviceRecord")
public class TSpecialDeviceRecordController extends BaseController
{
    @Autowired
    private ITSpecialDeviceRecordService tSpecialDeviceRecordService;

    /**
     * 查询特种设备台账列表
     */
    //@PreAuthorize("@ss.hasPermi('deviceManagement:specialDeviceRecord:list')")
    @GetMapping("/list")
    public TableDataInfo list(TSpecialDeviceRecord tSpecialDeviceRecord)
    {
        startPage();
        List<TSpecialDeviceRecordVo> list = tSpecialDeviceRecordService.selectTSpecialDeviceRecordList(tSpecialDeviceRecord);
        return getDataTable(list);
    }

    /**
     * 导出特种设备台账列表
     */
    @Log(title = "特种设备台账", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TSpecialDeviceRecord tSpecialDeviceRecord)
    {
        List<TSpecialDeviceRecordVo> list = tSpecialDeviceRecordService.selectTSpecialDeviceRecordList(tSpecialDeviceRecord);
        ExcelUtil<TSpecialDeviceRecordVo> util = new ExcelUtil<TSpecialDeviceRecordVo>(TSpecialDeviceRecordVo.class);
        return util.exportExcel(list, "特种设备台账数据");
    }

    /**
     * 获取特种设备台账详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tSpecialDeviceRecordService.selectTSpecialDeviceRecordById(id));
    }

    /**
     * 新增特种设备台账
     */
    @Log(title = "特种设备台账", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TSpecialDeviceRecord tSpecialDeviceRecord)
    {
        return toAjax(tSpecialDeviceRecordService.insertTSpecialDeviceRecord(tSpecialDeviceRecord));
    }

    /**
     * 修改特种设备台账
     */
    @Log(title = "特种设备台账", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TSpecialDeviceRecord tSpecialDeviceRecord)
    {
        return toAjax(tSpecialDeviceRecordService.updateTSpecialDeviceRecord(tSpecialDeviceRecord));
    }

    /**
     * 删除特种设备台账
     */
    @Log(title = "特种设备台账", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tSpecialDeviceRecordService.deleteTSpecialDeviceRecordByIds(ids));
    }
}
