package com.zehong.web.controller.contractTrain;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TContractorTrainCourseTopic;
import com.zehong.system.service.ITContractorTrainCourseTopicService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 承包商及访客培训题库Controller
 *
 * @author zehong
 * @date 2022-12-27
 */
@RestController
@RequestMapping("/contractTrainTopic")
public class TContractorTrainCourseTopicController extends BaseController
{
    @Autowired
    private ITContractorTrainCourseTopicService tContractorTrainCourseTopicService;

    /**
     * 查询承包商及访客培训题库列表
     */
    //@PreAuthorize("@ss.hasPermi('system:topic:list')")
    @GetMapping("/list")
    public TableDataInfo list(TContractorTrainCourseTopic tContractorTrainCourseTopic)
    {
        startPage();
        List<TContractorTrainCourseTopic> list = tContractorTrainCourseTopicService.selectTContractorTrainCourseTopicList(tContractorTrainCourseTopic);
        return getDataTable(list);
    }

    /**
     * 导出承包商及访客培训题库列表
     */
    //@PreAuthorize("@ss.hasPermi('system:topic:export')")
    @Log(title = "承包商及访客培训题库", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TContractorTrainCourseTopic tContractorTrainCourseTopic)
    {
        List<TContractorTrainCourseTopic> list = tContractorTrainCourseTopicService.selectTContractorTrainCourseTopicList(tContractorTrainCourseTopic);
        ExcelUtil<TContractorTrainCourseTopic> util = new ExcelUtil<TContractorTrainCourseTopic>(TContractorTrainCourseTopic.class);
        return util.exportExcel(list, "承包商及访客培训题库数据");
    }

    /**
     * 获取承包商及访客培训题库详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:topic:query')")
    @GetMapping(value = "/{topicId}")
    public AjaxResult getInfo(@PathVariable("topicId") Long topicId)
    {
        return AjaxResult.success(tContractorTrainCourseTopicService.selectTContractorTrainCourseTopicById(topicId));
    }

    /**
     * 新增承包商及访客培训题库
     */
    //@PreAuthorize("@ss.hasPermi('system:topic:add')")
    @Log(title = "承包商及访客培训题库", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TContractorTrainCourseTopic tContractorTrainCourseTopic)
    {
        return toAjax(tContractorTrainCourseTopicService.insertTContractorTrainCourseTopic(tContractorTrainCourseTopic));
    }

    /**
     * 修改承包商及访客培训题库
     */
    //@PreAuthorize("@ss.hasPermi('system:topic:edit')")
    @Log(title = "承包商及访客培训题库", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TContractorTrainCourseTopic tContractorTrainCourseTopic)
    {
        return toAjax(tContractorTrainCourseTopicService.updateTContractorTrainCourseTopic(tContractorTrainCourseTopic));
    }

    /**
     * 删除承包商及访客培训题库
     */
    //@PreAuthorize("@ss.hasPermi('system:topic:remove')")
    @Log(title = "承包商及访客培训题库", businessType = BusinessType.DELETE)
	@DeleteMapping("/{topicIds}")
    public AjaxResult remove(@PathVariable Long[] topicIds)
    {
        return toAjax(tContractorTrainCourseTopicService.deleteTContractorTrainCourseTopicByIds(topicIds));
    }
}
