package com.zehong.web.controller.contractTrain;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TContractorTrainCourse;
import com.zehong.system.service.ITContractorTrainCourseService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 承包商及访客培训Controller
 *
 * @author zehong
 * @date 2022-12-27
 */
@RestController
@RequestMapping("/contractTrain")
public class TContractorTrainCourseController extends BaseController
{
    @Autowired
    private ITContractorTrainCourseService tContractorTrainCourseService;

    /**
     * 查询承包商及访客培训列表
     */
    //@PreAuthorize("@ss.hasPermi('system:course:list')")
    @GetMapping("/list")
    public TableDataInfo list(TContractorTrainCourse tContractorTrainCourse)
    {
        startPage();
        List<TContractorTrainCourse> list = tContractorTrainCourseService.selectTContractorTrainCourseList(tContractorTrainCourse);
        return getDataTable(list);
    }

    /**
     * 查询承包商及访客培训信息
     * @param tContractorTrainCourse
     * @return
     */
    @GetMapping("/getITContractorTrainCourse")
    public AjaxResult getITContractorTrainCourse(TContractorTrainCourse tContractorTrainCourse){
        return AjaxResult.success(tContractorTrainCourseService.getITContractorTrainCourse(tContractorTrainCourse));
    }

    /**
     * 导出承包商及访客培训列表
     */
    //@PreAuthorize("@ss.hasPermi('system:course:export')")
    @Log(title = "承包商及访客培训", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TContractorTrainCourse tContractorTrainCourse)
    {
        List<TContractorTrainCourse> list = tContractorTrainCourseService.selectTContractorTrainCourseList(tContractorTrainCourse);
        ExcelUtil<TContractorTrainCourse> util = new ExcelUtil<TContractorTrainCourse>(TContractorTrainCourse.class);
        return util.exportExcel(list, "承包商及访客培训数据");
    }

    /**
     * 获取承包商及访客培训详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:course:query')")
    @GetMapping(value = "/{contractorCourseId}")
    public AjaxResult getInfo(@PathVariable("contractorCourseId") Long contractorCourseId)
    {
        return AjaxResult.success(tContractorTrainCourseService.selectTContractorTrainCourseById(contractorCourseId));
    }

    /**
     * 新增承包商及访客培训
     */
    //@PreAuthorize("@ss.hasPermi('system:course:add')")
    @Log(title = "承包商及访客培训", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TContractorTrainCourse tContractorTrainCourse)
    {
        return toAjax(tContractorTrainCourseService.insertTContractorTrainCourse(tContractorTrainCourse));
    }

    /**
     * 修改承包商及访客培训
     */
    //@PreAuthorize("@ss.hasPermi('system:course:edit')")
    @Log(title = "承包商及访客培训", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TContractorTrainCourse tContractorTrainCourse)
    {
        return toAjax(tContractorTrainCourseService.updateTContractorTrainCourse(tContractorTrainCourse));
    }

    /**
     * 删除承包商及访客培训
     */
    //@PreAuthorize("@ss.hasPermi('system:course:remove')")
    @Log(title = "承包商及访客培训", businessType = BusinessType.DELETE)
	@DeleteMapping("/{contractorCourseIds}")
    public AjaxResult remove(@PathVariable Long[] contractorCourseIds)
    {
        return toAjax(tContractorTrainCourseService.deleteTContractorTrainCourseByIds(contractorCourseIds));
    }
}
