package com.zehong.web.controller.arcfacecompare;

import com.arcsoft.face.toolkit.ImageFactory;
import com.arcsoft.face.toolkit.ImageInfo;
import com.zehong.web.arcface.util.FaceEngineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.util.HashMap;
import java.util.Map;

/**
 * @author geng
 * 人脸识别
 */
@RestController
@RequestMapping("/arcFace")
public class FaceCompareController {
    private static final Logger logger = LoggerFactory.getLogger(FaceCompareController.class);

    @Autowired
    private FaceEngineUtils faceEngineUtil;

    /**
     * 图片比对
     * @param file 待比对图片
     * @param compareFile 比对图片
     * @return Integer
     */
    @PostMapping(value = "/compare")
    public Map<String,Object> compare(@RequestParam(value = "file")MultipartFile file, @RequestParam(value = "compareFile")MultipartFile compareFile){
        Map<String,Object> result = new HashMap<>(16);
        try {
            ImageInfo rgbData1 = ImageFactory.getRGBData(file.getBytes());
            ImageInfo rgbData2 = ImageFactory.getRGBData(compareFile.getBytes());
            result.put("code","0");
            result.put("faceSimilar",faceEngineUtil.compareFace(rgbData1,rgbData2));
            return result;
        } catch (Exception e) {
            result.put("code","1");
            result.put("msg",e.getMessage());
            logger.error("图片比对系统错误：" + e);
            return result;
        }
    }
}
