package com.zehong.web.arcface.factory;

import com.arcsoft.face.EngineConfiguration;
import com.arcsoft.face.FaceEngine;
import com.arcsoft.face.enums.ErrorInfo;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author geng
 * 人脸识别引擎初始化
 */
public class FaceEngineFactory extends BasePooledObjectFactory<FaceEngine> {

    private static final Logger logger = LoggerFactory.getLogger(FaceEngineFactory.class);

    private String appId;
    private String sdkKey;
    private String sdkLibPath;
    private EngineConfiguration engineConfiguration;


    public FaceEngineFactory(String sdkLibPath, String appId, String sdkKey, EngineConfiguration engineConfiguration) {
        this.sdkLibPath = sdkLibPath;
        this.appId = appId;
        this.sdkKey = sdkKey;
        this.engineConfiguration = engineConfiguration;

    }


    @Override
    public FaceEngine create() throws Exception {

        FaceEngine faceEngine = new FaceEngine(System.getProperty("user.dir") + sdkLibPath);
        int activeCode = faceEngine.activeOnline(appId, sdkKey);
        logger.info("faceEngineActiveCode:" + activeCode + "==========================");
        if (activeCode != ErrorInfo.MOK.getValue() && activeCode != ErrorInfo.MERR_ASF_ALREADY_ACTIVATED.getValue()) {
            logger.error("引擎激活失败" + activeCode);
            throw new Exception("引擎激活失败" + activeCode);
        }
        int initCode = faceEngine.init(engineConfiguration);
        logger.info("faceEngineInitCode:" + initCode + "==========================");
        if (initCode != ErrorInfo.MOK.getValue()) {
            logger.error("引擎初始化失败" + initCode);
            throw new Exception( "引擎初始化失败" + initCode);
        }
        return faceEngine;
    }

    @Override
    public PooledObject<FaceEngine> wrap(FaceEngine faceEngine) {
        return new DefaultPooledObject<>(faceEngine);
    }


    @Override
    public void destroyObject(PooledObject<FaceEngine> p) throws Exception {
        FaceEngine faceEngine = p.getObject();
        int unInitCode = faceEngine.unInit();
        logger.info("faceEngineUnInitCode:" + unInitCode + "==========================");
        super.destroyObject(p);
    }
}
