import request from '@/utils/request'

// 查询特殊作业许可证列表
export function listSpecialPermit(query) {
  return request({
    url: '/special/permit/list',
    method: 'get',
    params: query
  })
}

export function getSpecialWorkPermitByWorkPermitId(query){
  return request({
    url: '/special/permit/getSpecialWorkPermitByWorkPermitId',
    method: 'get',
    params: query
  })
}

// 查询特殊作业许可证详细
export function getSpecialPermit(specialWorkPermitId) {
  return request({
    url: '/special/permit/' + specialWorkPermitId,
    method: 'get'
  })
}

// 新增特殊作业许可证
export function addSpecialPermit(data) {
  return request({
    url: '/special/permit',
    method: 'post',
    data: data
  })
}


// 批量新增特殊作业许可证
export function addBatchSpecialPermit(data) {
  return request({
    url: '/special/permit/addSpecialPermit',
    method: 'post',
    data: data
  })
}

// 修改特殊作业许可证
export function updateSpecialPermit(data) {
  return request({
    url: '/special/permit',
    method: 'put',
    data: data
  })
}

// 删除特殊作业许可证
export function delSpecialPermit(specialWorkPermitId) {
  return request({
    url: '/special/permit/' + specialWorkPermitId,
    method: 'delete'
  })
}

// 导出特殊作业许可证
export function exportSpecialPermit(query) {
  return request({
    url: '/special/permit/export',
    method: 'get',
    params: query
  })
}

export function updateSpecialWorkStatus(query) {
  return request({
    url: '/special/permit/updateSpecialWorkStatus',
    method: 'post',
    data: query
  })
}
