import request from '@/utils/request'

// 查询巡检任务信息列表
export function listWorkinfo(query) {
  return request({
    url: '/system/workinfo/list',
    method: 'get',
    params: query
  })
}
// 查询巡检任务信息列表
export function listTwoWorkinfo(query) {
  return request({
    url: '/system/workinfo/listTwo',
    method: 'get',
    params: query
  })
}
// 查询巡检任务信息详细
export function getWorkinfo(workId) {
  return request({
    url: '/system/workinfo/' + workId,
    method: 'get'
  })
}

// 新增巡检任务信息
export function addWorkinfo(data) {
  return request({
    url: '/system/workinfo',
    method: 'post',
    data: data
  })
}

// 修改巡检任务信息
export function updateWorkinfo(data) {
  return request({
    url: '/system/workinfo',
    method: 'put',
    data: data
  })
}

// 删除巡检任务信息
export function delWorkinfo(workId) {
  return request({
    url: '/system/workinfo/' + workId,
    method: 'delete'
  })
}

// 导出巡检任务信息
export function exportWorkinfo(query) {
  return request({
    url: '/system/workinfo/export',
    method: 'get',
    params: query
  })
}
// 巡检点树
export function treeDetail() {
  return request({
    url: '/system/position/treeDetail',
    method: 'get'
  })
}
