import request from '@/utils/request'

// 查询隐患排查任务列表
export function listWorkCheck(query) {
  return request({
    url: '/system/workCheck/list',
    method: 'get',
    params: query
  })
}

// 查询隐患排查任务详细
export function getWorkCheck(workId) {
  return request({
    url: '/system/workCheck/' + workId,
    method: 'get'
  })
}

// 新增隐患排查任务
export function addWorkCheck(data) {
  return request({
    url: '/system/workCheck',
    method: 'post',
    data: data
  })
}

// 修改隐患排查任务
export function updateWorkCheck(data) {
  return request({
    url: '/system/workCheck',
    method: 'put',
    data: data
  })
}

// 删除隐患排查任务
export function delWorkCheck(workId) {
  return request({
    url: '/system/workCheck/' + workId,
    method: 'delete'
  })
}

// 导出隐患排查任务
export function exportWorkCheck(query) {
  return request({
    url: '/system/workCheck/export',
    method: 'get',
    params: query
  })
}