import request from '@/utils/request'

// 查询巡检点记录信息列表
export function listRecorde(query) {
  return request({
    url: '/system/recorde/list',
    method: 'get',
    params: query
  })
}

// 查询巡检点记录信息详细
export function getRecorde(pointId) {
  return request({
    url: '/system/recorde/' + pointId,
    method: 'get'
  })
}

// 新增巡检点记录信息
export function addRecorde(data) {
  return request({
    url: '/system/recorde',
    method: 'post',
    data: data
  })
}

// 修改巡检点记录信息
export function updateRecorde(data) {
  return request({
    url: '/system/recorde',
    method: 'put',
    data: data
  })
}

// 删除巡检点记录信息
export function delRecorde(pointId) {
  return request({
    url: '/system/recorde/' + pointId,
    method: 'delete'
  })
}

// 导出巡检点记录信息
export function exportRecorde(query) {
  return request({
    url: '/system/recorde/export',
    method: 'get',
    params: query
  })
}