import request from '@/utils/request'

// 查询【请填写功能名称】列表
export function listManager(query) {
  return request({
    url: '/system/riskManager/list',
    method: 'get',
    params: query
  })
}

// 查询【请填写功能名称】详细
export function getManager(id) {
  return request({
    url: '/system/riskManager/' + id,
    method: 'get'
  })
}

// 新增【请填写功能名称】
export function addManager(data) {
  return request({
    url: '/system/riskManager',
    method: 'post',
    data: data
  })
}

// 修改【请填写功能名称】
export function updateManager(data) {
  return request({
    url: '/system/riskManager',
    method: 'put',
    data: data
  })
}

// 删除【请填写功能名称】
export function delManager(id) {
  return request({
    url: '/system/riskManager/' + id,
    method: 'delete'
  })
}

// 导出【请填写功能名称】
export function exportManager(query) {
  return request({
    url: '/system/riskManager/export',
    method: 'get',
    params: query
  })
}
