import request from '@/utils/request'

// 查询应急演练列表
export function listDrill(query) {
  return request({
    url: '/system/drill/list',
    method: 'get',
    params: query
  })
}

// 查询应急演练详细
export function getDrill(drillId) {
  return request({
    url: '/system/drill/' + drillId,
    method: 'get'
  })
}

// 新增应急演练
export function addDrill(data) {
  return request({
    url: '/system/drill',
    method: 'post',
    data: data
  })
}

// 修改应急演练
export function updateDrill(data) {
  return request({
    url: '/system/drill',
    method: 'put',
    data: data
  })
}

// 删除应急演练
export function delDrill(drillId) {
  return request({
    url: '/system/drill/' + drillId,
    method: 'delete'
  })
}

// 导出应急演练
export function exportDrill(query) {
  return request({
    url: '/system/drill/export',
    method: 'get',
    params: query
  })
}