import request from '@/utils/request'

// 查询排查评估列表
export function listAssessment(query) {
  return request({
    url: '/system/assessment/list',
    method: 'get',
    params: query
  })
}

// 查询排查评估详细
export function getAssessment(assessmentId) {
  return request({
    url: '/system/assessment/' + assessmentId,
    method: 'get'
  })
}
export function getAssessmentWorkId(workId) {
  return request({
    url: '/system/assessment/workId/' + workId,
    method: 'get'
  })
}

// 新增排查评估
export function addAssessment(data) {
  return request({
    url: '/system/assessment',
    method: 'post',
    data: data
  })
}

// 修改排查评估
export function updateAssessment(data) {
  return request({
    url: '/system/assessment',
    method: 'put',
    data: data
  })
}

// 删除排查评估
export function delAssessment(assessmentId) {
  return request({
    url: '/system/assessment/' + assessmentId,
    method: 'delete'
  })
}

// 导出排查评估
export function exportAssessment(query) {
  return request({
    url: '/system/assessment/export',
    method: 'get',
    params: query
  })
}
