import request from '@/utils/request'

// 查询报警记录列表
export function listAlarm(query) {
  return request({
    url: '/system/alarm/list',
    method: 'get',
    params: query
  })
}
//statistics
export function getStatistics() {
  return request({
    url: '/system/alarm/statistics',
    method: 'get',
  })
}
// 查询报警记录详细
export function getAlarm(alarmId) {
  return request({
    url: '/system/alarm/' + alarmId,
    method: 'get'
  })
}

// 新增报警记录
export function addAlarm(data) {
  return request({
    url: '/system/alarm',
    method: 'post',
    data: data
  })
}

// 修改报警记录
export function updateAlarm(data) {
  return request({
    url: '/system/alarm',
    method: 'put',
    data: data
  })
}

// 删除报警记录
export function delAlarm(alarmId) {
  return request({
    url: '/system/alarm/' + alarmId,
    method: 'delete'
  })
}

// 导出报警记录
export function exportAlarm(query) {
  return request({
    url: '/system/alarm/export',
    method: 'get',
    params: query
  })
}
