import request from '@/utils/request'
import { praseStrEmpty } from "@/utils/zehong";

// 查询员工信息管理列表
export function listStaff(query) {
  return request({
    url: '/safetyManagement/staff/list',
    method: 'get',
    params: query
  })
}

// 查询员工信息管理详细
export function getStaff(staffId) {
  return request({
    url: '/safetyManagement/staff/' + praseStrEmpty(staffId),
    method: 'get'
  })
}

// 新增员工信息管理
export function addStaff(data) {
  return request({
    url: '/safetyManagement/staff',
    method: 'post',
    data: data
  })
}

// 修改员工信息管理
export function updateStaff(data) {
  return request({
    url: '/safetyManagement/staff',
    method: 'put',
    data: data
  })
}

// 删除员工信息管理
export function delStaff(staffId) {
  return request({
    url: '/safetyManagement/staff/' + staffId,
    method: 'delete'
  })
}

// 导出员工信息管理
export function exportStaff(query) {
  return request({
    url: '/safetyManagement/staff/export',
    method: 'get',
    params: query
  })
}
