import request from '@/utils/request'

// 查询企业资质证照管理列表
export function listEnterpriseCertificate(query) {
  return request({
    url: '/safetyManagement/enterpriseCertificate/list',
    method: 'get',
    params: query
  })
}

// 查询企业资质证照管理详细
export function getEnterpriseCertificate(id) {
  return request({
    url: '/safetyManagement/enterpriseCertificate/' + id,
    method: 'get'
  })
}

// 新增企业资质证照管理
export function addEnterpriseCertificate(data) {
  return request({
    url: '/safetyManagement/enterpriseCertificate',
    method: 'post',
    data: data
  })
}

// 修改企业资质证照管理
export function updateEnterpriseCertificate(data) {
  return request({
    url: '/safetyManagement/enterpriseCertificate',
    method: 'put',
    data: data
  })
}

// 删除企业资质证照管理
export function delEnterpriseCertificate(id) {
  return request({
    url: '/safetyManagement/enterpriseCertificate/' + id,
    method: 'delete'
  })
}

// 导出企业资质证照管理
export function exportEnterpriseCertificate(query) {
  return request({
    url: '/safetyManagement/enterpriseCertificate/export',
    method: 'get',
    params: query
  })
}