import request from '@/utils/request'

// 查询上图设备监测列表
export function listMonitor(query) {
  return request({
    url: '/map/monitor/list',
    method: 'get',
    params: query
  })
}

// 查询上图设备监测详细
export function getMonitor(monitorId) {
  return request({
    url: '/map/monitor/' + monitorId,
    method: 'get'
  })
}

// 新增上图设备监测
export function addMonitor(data) {
  return request({
    url: '/map/monitor',
    method: 'post',
    data: data
  })
}

// 修改上图设备监测
export function updateMonitor(data) {
  return request({
    url: '/map/monitor',
    method: 'put',
    data: data
  })
}

// 删除上图设备监测
export function delMonitor(monitorId) {
  return request({
    url: '/map/monitor/' + monitorId,
    method: 'delete'
  })
}

// 导出上图设备监测
export function exportMonitor(query) {
  return request({
    url: '/map/monitor/export',
    method: 'get',
    params: query
  })
}
