import request from '@/utils/request'

// 查询应急通讯人员管理列表
export function listCrew(query) {
  return request({
    url: '/emergency/crew/list',
    method: 'get',
    params: query
  })
}

// 查询应急通讯人员管理详细
export function getCrew(communicationId) {
  return request({
    url: '/emergency/crew/' + communicationId,
    method: 'get'
  })
}

// 新增应急通讯人员管理
export function addCrew(data) {
  return request({
    url: '/emergency/crew',
    method: 'post',
    data: data
  })
}

// 修改应急通讯人员管理
export function updateCrew(data) {
  return request({
    url: '/emergency/crew',
    method: 'put',
    data: data
  })
}

// 删除应急通讯人员管理
export function delCrew(communicationId) {
  return request({
    url: '/emergency/crew/' + communicationId,
    method: 'delete'
  })
}

// 导出应急通讯人员管理
export function exportCrew(query) {
  return request({
    url: '/emergency/crew/export',
    method: 'get',
    params: query
  })
}