/*
 * @Author: 纪泽龙 jizelong@qq.com
 * @Date: 2022-09-23 11:02:24
 * @LastEditors: 纪泽龙 jizelong@qq.com
 * @LastEditTime: 2022-09-28 11:37:33
 * @FilePath: /danger-manage-web/src/api/educationPlanExam/trainingProgram.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import request from '@/utils/request'
//培训计划管理


// 获取所有课程
export function getLessons(query) {
  return request({
    url: '/system/course/list',
    method: 'get',
    params: query
  })
}

// 当前用户的课程列表
export function getUserLessons(query) {
  return request({
    url: 'system/course/userCourseList',
    method: 'get',
    params: query
  })
}
// 用id查询课程
export function getLessonById(id) {
  return request({
    url: 'system/course/'+id,
    method: 'get',
  })
}
// 添加课程
export function addLessons(data) {
  return request({
    url: '/system/course',
    method: 'post',
    data: data
  })
}
// // 修改课程
export function changeLesson(data) {
  return request({
    url: '/system/course',
    method: 'put',
    data:data
  })
}

// 发布课程
export function issue(query) {
  return request({
    url: '/system/course/release',
    method: 'get',
    params: query
  })
}
// 删除课程
export function deleteLesson(query) {
  return request({
    url: '/system/course/'+query,
    method: 'delete',
  })
}





// 获取课程的题目详情列表列表
export function getQuestion(query) {
  return request({
    url: '/system/topic/list',
    method: 'get',
    params: query
  })
}




// 添加课程考试题目
export function addQuestion(data) {
  return request({
    url: '/system/topic',
    method: 'post',
    data: data
  })
}
// 修改课程考试题目
export function changeQuestion(data) {
  return request({
    url: '/system/topic',
    method: 'put',
    data: data
  })
}
// 删除
export function deleteQuestion(query) {
  return request({
    url: 'system/topic/'+query,
    method: 'delete',
    // params: query
  })
}
// 查看单独题目
export function checkQuestion(query) {
  return request({
    url: '/system/topic/'+query,
    method: 'get',
  })
}
// 考试的题目
export function userQuestionList(query) {
  return request({
    url: '/system/topic/topiclist',
    method: 'get',
    params: query
  })
}

// 交卷
export function setAnswer(query) {
  return request({
    url: '/system/course/examination',
    method: 'get',
    params: query
  })
}

