import request from '@/utils/request'

// 查询设备维修工单列表
export function listRepairOrder(query) {
  return request({
    url: '/deviceManagement/repairOrder/list',
    method: 'get',
    params: query
  })
}

// 查询设备维修工单详细
export function getRepairOrder(id) {
  return request({
    url: '/deviceManagement/repairOrder/' + id,
    method: 'get'
  })
}

// 新增设备维修工单
export function addRepairOrder(data) {
  return request({
    url: '/deviceManagement/repairOrder',
    method: 'post',
    data: data
  })
}

// 修改设备维修工单
export function updateRepairOrder(data) {
  return request({
    url: '/deviceManagement/repairOrder',
    method: 'put',
    data: data
  })
}

// 删除设备维修工单
export function delRepairOrder(id) {
  return request({
    url: '/deviceManagement/repairOrder/' + id,
    method: 'delete'
  })
}

// 导出设备维修工单
export function exportRepairOrder(query) {
  return request({
    url: '/deviceManagement/repairOrder/export',
    method: 'get',
    params: query
  })
}