import request from '@/utils/request'

// 查询承包商人员信息列表
export function listContractorPerson(query) {
  return request({
    url: '/contractor/contractorPerson/list',
    method: 'get',
    params: query
  })
}

// 查询承包商人员信息详细
export function getContractorPerson(id) {
  return request({
    url: '/contractor/contractorPerson/' + id,
    method: 'get'
  })
}

// 新增承包商人员信息
export function addContractorPerson(data) {
  return request({
    url: '/contractor/contractorPerson',
    method: 'post',
    data: data
  })
}

// 修改承包商人员信息
export function updateContractorPerson(data) {
  return request({
    url: '/contractor/contractorPerson',
    method: 'put',
    data: data
  })
}

// 删除承包商人员信息
export function delContractorPerson(id) {
  return request({
    url: '/contractor/contractorPerson/' + id,
    method: 'delete'
  })
}

// 导出承包商人员信息
export function exportContractorPerson(query) {
  return request({
    url: '/contractor/contractorPerson/export',
    method: 'get',
    params: query
  })
}