import request from '@/utils/request'

// 查询承包商信息列表
export function listContractorInfo(query) {
  return request({
    url: '/contractor/contractorInfo/list',
    method: 'get',
    params: query
  })
}
// 查询承包商信息树
export function listAll(query) {
  return request({
    url: '/contractor/contractorInfo/listAll',
    method: 'get',
    params: query
  })
}

// 查询承包商信息详细
export function getContractorInfo(id) {
  return request({
    url: '/contractor/contractorInfo/' + id,
    method: 'get'
  })
}

// 新增承包商信息
export function addContractorInfo(data) {
  return request({
    url: '/contractor/contractorInfo',
    method: 'post',
    data: data
  })
}

// 修改承包商信息
export function updateContractorInfo(data) {
  return request({
    url: '/contractor/contractorInfo',
    method: 'put',
    data: data
  })
}

// 删除承包商信息
export function delContractorInfo(id) {
  return request({
    url: '/contractor/contractorInfo/' + id,
    method: 'delete'
  })
}

// 导出承包商信息
export function exportContractorInfo(query) {
  return request({
    url: '/contractor/contractorInfo/export',
    method: 'get',
    params: query
  })
}
