package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TWorkPermitMapper;
import com.zehong.system.domain.TWorkPermit;
import com.zehong.system.service.ITWorkPermitService;

/**
 * 作业许可证Service业务层处理
 * 
 * @author zehong
 * @date 2022-08-18
 */
@Service
public class TWorkPermitServiceImpl implements ITWorkPermitService 
{
    @Autowired
    private TWorkPermitMapper tWorkPermitMapper;

    /**
     * 查询作业许可证
     * 
     * @param workPermitId 作业许可证ID
     * @return 作业许可证
     */
    @Override
    public TWorkPermit selectTWorkPermitById(Long workPermitId)
    {
        return tWorkPermitMapper.selectTWorkPermitById(workPermitId);
    }

    /**
     * 查询作业许可证列表
     * 
     * @param tWorkPermit 作业许可证
     * @return 作业许可证
     */
    @Override
    public List<TWorkPermit> selectTWorkPermitList(TWorkPermit tWorkPermit)
    {
        return tWorkPermitMapper.selectTWorkPermitList(tWorkPermit);
    }

    /**
     * 新增作业许可证
     * 
     * @param tWorkPermit 作业许可证
     * @return 结果
     */
    @Override
    public int insertTWorkPermit(TWorkPermit tWorkPermit)
    {
        tWorkPermit.setCreateTime(DateUtils.getNowDate());
        return tWorkPermitMapper.insertTWorkPermit(tWorkPermit);
    }

    /**
     * 修改作业许可证
     * 
     * @param tWorkPermit 作业许可证
     * @return 结果
     */
    @Override
    public int updateTWorkPermit(TWorkPermit tWorkPermit)
    {
        tWorkPermit.setUpdateTime(DateUtils.getNowDate());
        return tWorkPermitMapper.updateTWorkPermit(tWorkPermit);
    }

    /**
     * 批量删除作业许可证
     * 
     * @param workPermitIds 需要删除的作业许可证ID
     * @return 结果
     */
    @Override
    public int deleteTWorkPermitByIds(Long[] workPermitIds)
    {
        return tWorkPermitMapper.deleteTWorkPermitByIds(workPermitIds);
    }

    /**
     * 删除作业许可证信息
     * 
     * @param workPermitId 作业许可证ID
     * @return 结果
     */
    @Override
    public int deleteTWorkPermitById(Long workPermitId)
    {
        return tWorkPermitMapper.deleteTWorkPermitById(workPermitId);
    }
}
