package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TTrainCourse;
import com.zehong.system.mapper.TTrainCourseMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TTrainCourseTopicMapper;
import com.zehong.system.domain.TTrainCourseTopic;
import com.zehong.system.service.ITTrainCourseTopicService;
import org.springframework.transaction.annotation.Transactional;

/**
 * 培训课程题库Service业务层处理
 * 
 * @author zehong
 * @date 2022-09-19
 */
@Service
public class TTrainCourseTopicServiceImpl implements ITTrainCourseTopicService 
{
    @Autowired
    private TTrainCourseTopicMapper tTrainCourseTopicMapper;
    @Autowired
    private TTrainCourseMapper tTrainCourseMapper;

    /**
     * 查询培训课程题库
     * 
     * @param topicId 培训课程题库ID
     * @return 培训课程题库
     */
    @Override
    public TTrainCourseTopic selectTTrainCourseTopicById(Long topicId)
    {
        return tTrainCourseTopicMapper.selectTTrainCourseTopicById(topicId);
    }

    /**
     * 查询培训课程题库列表
     * 
     * @param tTrainCourseTopic 培训课程题库
     * @return 培训课程题库
     */
    @Override
    public List<TTrainCourseTopic> selectTTrainCourseTopicList(TTrainCourseTopic tTrainCourseTopic)
    {
        return tTrainCourseTopicMapper.selectTTrainCourseTopicList(tTrainCourseTopic);
    }
    @Override
    public List<TTrainCourseTopic> selectCourseTopicList(Long courseId)
    {
        return tTrainCourseTopicMapper.selectCourseTopicList(courseId);
    }

    /**
     * 新增培训课程题库
     * 
     * @param tTrainCourseTopic 培训课程题库
     * @return 结果
     */
    @Override
    @Transactional
    public int insertTTrainCourseTopic(TTrainCourseTopic tTrainCourseTopic)
    {
        tTrainCourseTopic.setCreateTime(DateUtils.getNowDate());
        TTrainCourse course = tTrainCourseMapper.selectTTrainCourseById(tTrainCourseTopic.getCourseId());
        if(course!=null){
            course.setTopicNum(course.getTopicNum()+1);
            tTrainCourseMapper.updateTTrainCourse(course);
        }
        return tTrainCourseTopicMapper.insertTTrainCourseTopic(tTrainCourseTopic);
    }

    /**
     * 修改培训课程题库
     * 
     * @param tTrainCourseTopic 培训课程题库
     * @return 结果
     */
    @Override
    public int updateTTrainCourseTopic(TTrainCourseTopic tTrainCourseTopic)
    {
        return tTrainCourseTopicMapper.updateTTrainCourseTopic(tTrainCourseTopic);
    }

    /**
     * 批量删除培训课程题库
     * 
     * @param topicIds 需要删除的培训课程题库ID
     * @return 结果
     */
    @Override
    public int deleteTTrainCourseTopicByIds(Long[] topicIds)
    {
        return tTrainCourseTopicMapper.deleteTTrainCourseTopicByIds(topicIds);
    }

    /**
     * 删除培训课程题库信息
     * 
     * @param topicId 培训课程题库ID
     * @return 结果
     */
    @Override
    @Transactional
    public int deleteTTrainCourseTopicById(Long topicId)
    {
        TTrainCourseTopic topic = tTrainCourseTopicMapper.selectTTrainCourseTopicById(topicId);
        if(topic==null){
            return 0;
        }
        TTrainCourse course = tTrainCourseMapper.selectTTrainCourseById(topic.getCourseId());
        if(course!=null){
            course.setTopicNum(course.getTopicNum()-1);
            tTrainCourseMapper.updateTTrainCourse(course);
        }
        return tTrainCourseTopicMapper.deleteTTrainCourseTopicById(topicId);
    }
}
