package com.zehong.system.service.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TTrainCourseTopic;
import com.zehong.system.domain.TTrainPlan;
import com.zehong.system.domain.TTrainUserCourse;
import com.zehong.system.domain.vo.UserCourseVo;
import com.zehong.system.mapper.TTrainCourseTopicMapper;
import com.zehong.system.mapper.TTrainPlanMapper;
import com.zehong.system.mapper.TTrainUserCourseMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TTrainCourseMapper;
import com.zehong.system.domain.TTrainCourse;
import com.zehong.system.service.ITTrainCourseService;
import org.springframework.transaction.annotation.Transactional;

/**
 * 培训课程Service业务层处理
 * 
 * @author zehong
 * @date 2022-09-19
 */
@Service
public class TTrainCourseServiceImpl implements ITTrainCourseService 
{
    @Autowired
    private TTrainCourseMapper tTrainCourseMapper;
    @Autowired
    private TTrainPlanMapper tTrainPlanMapper;
    @Autowired
    private TTrainUserCourseMapper tTrainUserCourseMapper;
    @Autowired
    private TTrainCourseTopicMapper tTrainCourseTopicMapper;

    /**
     * 查询培训课程
     * 
     * @param courseId 培训课程ID
     * @return 培训课程
     */
    @Override
    public TTrainCourse selectTTrainCourseById(Long courseId)
    {
        return tTrainCourseMapper.selectTTrainCourseById(courseId);
    }

    /**
     * 发布培训课程
     * @return
     */
    @Override
    @Transactional
    public Integer selectTTrainCourseRelease(Long courseId){
         TTrainCourse course = tTrainCourseMapper.selectTTrainCourseById(courseId);
         if(course==null){
             return 0;
         }
         List<String> userIds = tTrainPlanMapper.selectAlluserByplanId(course.getCourseType());
        tTrainCourseMapper.insertUserCourse(courseId,userIds);
         course.setStatus(1);
         course.setReleaseTime(new Date());
         return tTrainCourseMapper.updateTTrainCourse(course);
    }
    /**
     * 查询培训课程列表
     * 
     * @param tTrainCourse 培训课程
     * @return 培训课程
     */
    @Override
    public List<TTrainCourse> selectTTrainCourseList(TTrainCourse tTrainCourse)
    {
        return tTrainCourseMapper.selectTTrainCourseList(tTrainCourse);
    }

    /**
     * 新增培训课程
     * 
     * @param tTrainCourse 培训课程
     * @return 结果
     */
    @Override
    public Long insertTTrainCourse(TTrainCourse tTrainCourse)
    {
        tTrainCourse.setCreateTime(DateUtils.getNowDate());
        tTrainCourseMapper.insertTTrainCourse(tTrainCourse);
        return tTrainCourse.getCourseId();
    }

    /**
     * 修改培训课程
     * 
     * @param tTrainCourse 培训课程
     * @return 结果
     */
    @Override
    public int updateTTrainCourse(TTrainCourse tTrainCourse)
    {
        return tTrainCourseMapper.updateTTrainCourse(tTrainCourse);
    }

    /**
     * 批量删除培训课程
     * 
     * @param courseIds 需要删除的培训课程ID
     * @return 结果
     */
    @Override
    public int deleteTTrainCourseByIds(Long[] courseIds)
    {
        return tTrainCourseMapper.deleteTTrainCourseByIds(courseIds);
    }

    /**
     * 删除培训课程信息
     * 
     * @param courseId 培训课程ID
     * @return 结果
     */
    @Override
    public int deleteTTrainCourseById(Long courseId)
    {
        return tTrainCourseMapper.deleteTTrainCourseById(courseId);
    }

    /**
     * 用户课程表
     * @return
     */
    @Override
    public List<UserCourseVo> userCourseList(Long userId,Integer type){
        List<UserCourseVo> list = tTrainCourseMapper.userCourseList(userId,type);
        return list;
    }

    /**
     * 考试判断
     * @param userCourseId
     * @param answers
     * @return
     */
    @Override
    @Transactional
    public Map<String,Object> examination (Long userCourseId,String[] answers){
        TTrainUserCourse userCourse = tTrainUserCourseMapper.selectTTrainUserCourseById(userCourseId);
        TTrainCourseTopic topic = new TTrainCourseTopic();
        topic.setCourseId(userCourse.getCourseId());
        List<TTrainCourseTopic> list = tTrainCourseTopicMapper.selectTTrainCourseTopicList(topic);
        int num = 0;
        for(Integer i=0;i<answers.length;i++){
            if(Integer.parseInt(answers[i])==list.get(i).getAnswer()){
                num++;
            }
        }
        userCourse.setExaminationResult(num);
        userCourse.setExaminationTime(new Date());
        TTrainCourse c = tTrainCourseMapper.selectTTrainCourseById(userCourse.getCourseId());
        if(num>=c.getQualifiedNum()){
            userCourse.setState(2);
        }else {
            userCourse.setState(1);
        }
        tTrainUserCourseMapper.updateTTrainUserCourse(userCourse);
        Map<String,Object> map = new HashMap<>();
        map.put("answer",num);
        map.put("qualifiedNum",c.getQualifiedNum());
        map.put("topicNum",list.size());
        return map;
    }
}
