package com.zehong.system.service.impl;

import java.util.List;

import com.zehong.common.core.domain.entity.SysDept;
import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.THiddenTroubleWork;
import com.zehong.system.mapper.SysDeptMapper;
import com.zehong.system.mapper.THiddenTroubleWorkMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TStaningBookMapper;
import com.zehong.system.domain.TStaningBook;
import com.zehong.system.service.ITStaningBookService;

/**
 * 隐患台账Service业务层处理
 * 
 * @author zehong
 * @date 2022-07-09
 */
@Service
public class TStaningBookServiceImpl implements ITStaningBookService 
{
    @Autowired
    private TStaningBookMapper tStaningBookMapper;
    @Autowired
    private THiddenTroubleWorkMapper tHiddenTroubleWorkMapper;
    @Autowired
    private SysDeptMapper deptMapper;

    /**
     * 查询隐患台账
     * 
     * @param bookId 隐患台账ID
     * @return 隐患台账
     */
    @Override
    public TStaningBook selectTStaningBookById(Long bookId)
    {
        return tStaningBookMapper.selectTStaningBookById(bookId);
    }

    /**
     * 查询隐患台账列表
     * 
     * @param tStaningBook 隐患台账
     * @return 隐患台账
     */
    @Override
    public List<TStaningBook> selectTStaningBookList(TStaningBook tStaningBook)
    {
        List<TStaningBook> list = tStaningBookMapper.selectTStaningBookList(tStaningBook);
//        for(TStaningBook book: list){
//            if(book.getDeptId()!=null){
//                SysDept dept = deptMapper.selectDeptById(book.getDeptId());
//                if(dept!=null){
//                    book.setDeptName(dept.getDeptName());
//                }
//            }
//        }
        return list;
    }

    /**
     * 新增隐患台账
     * 
     * @param tStaningBook 隐患台账
     * @return 结果
     */
    @Override
    public int insertTStaningBook(TStaningBook tStaningBook)
    {
        tStaningBook.setCreateTime(DateUtils.getNowDate());
        return tStaningBookMapper.insertTStaningBook(tStaningBook);
    }

    /**
     * 修改隐患台账
     * 
     * @param tStaningBook 隐患台账
     * @return 结果
     */
    @Override
    public int updateTStaningBook(TStaningBook tStaningBook)
    {
        return tStaningBookMapper.updateTStaningBook(tStaningBook);
    }

    /**
     * 批量删除隐患台账
     * 
     * @param bookIds 需要删除的隐患台账ID
     * @return 结果
     */
    @Override
    public int deleteTStaningBookByIds(Long[] bookIds)
    {
        return tStaningBookMapper.deleteTStaningBookByIds(bookIds);
    }

    /**
     * 删除隐患台账信息
     * 
     * @param bookId 隐患台账ID
     * @return 结果
     */
    @Override
    public int deleteTStaningBookById(Long bookId)
    {
        return tStaningBookMapper.deleteTStaningBookById(bookId);
    }
}
