package com.zehong.system.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.system.domain.TSpecialWorkPermit;
import com.zehong.system.domain.TWorkPermit;
import com.zehong.system.domain.vo.TWorkPermitVo;
import com.zehong.system.mapper.TSpecialWorkPermitMapper;
import com.zehong.system.service.ISysPostService;
import com.zehong.system.service.ITSpecialWorkPermitService;
import com.zehong.system.service.ITWorkPermitService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 特殊作业许可证Service业务层处理
 * 
 * @author zehong
 * @date 2022-08-25
 */
@Service
public class TSpecialWorkPermitServiceImpl implements ITSpecialWorkPermitService 
{
    @Resource
    private TSpecialWorkPermitMapper tSpecialWorkPermitMapper;

    @Resource
    private ITWorkPermitService itWorkPermitService;

    @Resource
    private ISysPostService postService;

    /**
     * 查询特殊作业许可证
     * 
     * @param specialWorkPermitId 特殊作业许可证ID
     * @return 特殊作业许可证
     */
    @Override
    public TSpecialWorkPermit selectTSpecialWorkPermitById(Long specialWorkPermitId)
    {
        return tSpecialWorkPermitMapper.selectTSpecialWorkPermitById(specialWorkPermitId);
    }

    /**
     * 查询特殊作业许可证列表
     * 
     * @param tSpecialWorkPermit 特殊作业许可证
     * @return 特殊作业许可证
     */
    @Override
    public List<TSpecialWorkPermit> selectTSpecialWorkPermitList(TSpecialWorkPermit tSpecialWorkPermit)
    {
        return tSpecialWorkPermitMapper.selectTSpecialWorkPermitList(tSpecialWorkPermit);
    }

    /**
     * 新增特殊作业许可证
     * 
     * @param tSpecialWorkPermit 特殊作业许可证
     * @return 结果
     */
    @Override
    public int insertTSpecialWorkPermit(TSpecialWorkPermit tSpecialWorkPermit)
    {
        tSpecialWorkPermit.setCreateTime(DateUtils.getNowDate());
        return tSpecialWorkPermitMapper.insertTSpecialWorkPermit(tSpecialWorkPermit);
    }

    /**
     * 修改特殊作业许可证
     * 
     * @param tSpecialWorkPermit 特殊作业许可证
     * @return 结果
     */
    @Override
    public int updateTSpecialWorkPermit(TSpecialWorkPermit tSpecialWorkPermit)
    {
        tSpecialWorkPermit.setUpdateTime(DateUtils.getNowDate());
        return tSpecialWorkPermitMapper.updateTSpecialWorkPermit(tSpecialWorkPermit);
    }

    /**
     * 批量删除特殊作业许可证
     * 
     * @param specialWorkPermitIds 需要删除的特殊作业许可证ID
     * @return 结果
     */
    @Override
    public int deleteTSpecialWorkPermitByIds(Long[] specialWorkPermitIds)
    {
        return tSpecialWorkPermitMapper.deleteTSpecialWorkPermitByIds(specialWorkPermitIds);
    }

    /**
     * 删除特殊作业许可证信息
     * 
     * @param specialWorkPermitId 特殊作业许可证ID
     * @return 结果
     */
    @Override
    public int deleteTSpecialWorkPermitById(Long specialWorkPermitId)
    {
        return tSpecialWorkPermitMapper.deleteTSpecialWorkPermitById(specialWorkPermitId);
    }

    /**
     * 批量新增特殊许可单
     * @param tWorkPermitVo 许可单实体
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int addSpecialPermit(TWorkPermitVo tWorkPermitVo){
        TWorkPermit tWorkPermit = itWorkPermitService.selectTWorkPermitById(tWorkPermitVo.gettWorkPermit().getWorkPermitId());
        JSONObject licence = JSON.parseObject(tWorkPermit.getLicenceInfo());
        for(TSpecialWorkPermit tSpecialWorkPermit : tWorkPermitVo.getSpecialWorkPermits()){
            JSONObject info = (JSONObject)licence.get(tSpecialWorkPermit.getSpecialWorkType());
            if((Boolean) info.get("isChecked")){
                if("2".equals(info.get("status"))){
                    TSpecialWorkPermit update = new TSpecialWorkPermit();
                    update.setSpecialWorkPermitId(tSpecialWorkPermit.getSpecialWorkPermitId());
                    update.setIsDel("1");
                    tSpecialWorkPermitMapper.updateTSpecialWorkPermit(update);
                }
                if(!"1".equals(info.get("status"))){
                    tSpecialWorkPermitMapper.insertTSpecialWorkPermit(tSpecialWorkPermit);
                }
            }
        }
        if("3".equals(tWorkPermitVo.gettWorkPermit().getApplyStatus())){
            //只遍历key
            for (String key : licence.keySet()) {
                if(key !="jsa" && key != "specialLicence" && key != "lockListing"){
                    JSONObject info = (JSONObject)licence.get(key);
                    if((Boolean) info.get("isChecked")){
                        if(!"1".equals(info.get("status"))){
                            info.put("status","0");
                        }
                    }
                }
            }
            tWorkPermitVo.gettWorkPermit().setLicenceInfo(JSON.toJSONString(licence));
        }
        return  itWorkPermitService.updateTWorkPermit(tWorkPermitVo.gettWorkPermit());
    }

    /**
     * 根据许可证id查询许可单
     * @param workPermitId 许可证id
     * @return
     */
    @Override
    public TWorkPermitVo getSpecialWorkPermitByWorkPermitId(Long workPermitId){
        TWorkPermitVo tWorkPermitVo = new TWorkPermitVo();
        TWorkPermit tWorkPermit = itWorkPermitService.selectTWorkPermitById(workPermitId);
        tWorkPermitVo.settWorkPermit(tWorkPermit);

        List<Integer> postIds = postService.selectPostListByUserId(SecurityUtils.getLoginUser().getUser().getUserId());
        if(SecurityUtils.getLoginUser().getUser().getUserId().equals(Long.valueOf(tWorkPermit.getLinkMan()))){
            postIds.add(-1);
        }
        if(SecurityUtils.getLoginUser().getUser().getUserId().equals(Long.valueOf(tWorkPermit.getRatifier()))){
            postIds.add(-2);
        }
        tWorkPermitVo.setPostIds(postIds);
        TSpecialWorkPermit tSpecialWorkPermit = new TSpecialWorkPermit();
        tSpecialWorkPermit.setWorkPermitId(workPermitId);
        tWorkPermitVo.setSpecialWorkPermits(tSpecialWorkPermitMapper.selectTSpecialWorkPermitList(tSpecialWorkPermit));
        return tWorkPermitVo;
    }

    /**
     * 更新作业单状态
     * @param tSpecialWorkPermit 特殊作业单
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int updateSpecialWorkStatus (TSpecialWorkPermit tSpecialWorkPermit){
        tSpecialWorkPermitMapper.updateTSpecialWorkPermit(tSpecialWorkPermit);
        //判断特殊作业单是否全部审批完成 审批完成更新作业单状态
        JSONObject specialWork = JSON.parseObject(tSpecialWorkPermit.getSpecialWorkData());
        //获取审批信息
        JSONObject auditingInfo = (JSONObject)specialWork.get("auditing");
        //0 待审核、1 审核通过、2 审核失败
        String singlLicenceStatus = "1";
        //判断作业单是否审批完成
        for(String key : auditingInfo.keySet()){
            JSONObject approvalInfo = (JSONObject) auditingInfo.get(key);
            if("0".equals(approvalInfo.get("status"))){
                return 0;
            }
        }
        //判断作业单有没有被驳回
        for(String key : auditingInfo.keySet()){
            JSONObject approvalInfo = (JSONObject) auditingInfo.get(key);
            if("2".equals(approvalInfo.get("status"))){
                singlLicenceStatus = "2";
                break;
            }
        }
        //获取作业证信息
        TWorkPermit tWorkPermit = itWorkPermitService.selectTWorkPermitById(tSpecialWorkPermit.getWorkPermitId());
        JSONObject licenceInfo = JSON.parseObject(tWorkPermit.getLicenceInfo());
        for(String key : licenceInfo.keySet()){
            if(key !="jsa" && key != "specialLicence" && key != "lockListing"){
                JSONObject work = (JSONObject)licenceInfo.get(key);
                if((Boolean) work.get("isChecked")){
                    if(key.equals(tSpecialWorkPermit.getSpecialWorkType())){
                        work.put("status",singlLicenceStatus);
                        tWorkPermit.setLicenceInfo(JSON.toJSONString(licenceInfo));
                        itWorkPermitService.updateTWorkPermit(tWorkPermit);
                    }
                }
            }
        }
        //判断是否所有作业单已审批完成
        for(String key : licenceInfo.keySet()){
            if(key !="jsa" && key != "specialLicence" && key != "lockListing"){
                JSONObject work = (JSONObject)licenceInfo.get(key);
                if((Boolean) work.get("isChecked")){
                    if ("0".equals(work.get("status"))){
                        return 0;
                    }
                }
            }
        }
        String licenceStatus = "4";
        for(String key : licenceInfo.keySet()){
            if(key !="jsa" && key != "specialLicence" && key != "lockListing"){
                JSONObject work = (JSONObject)licenceInfo.get(key);
                if((Boolean) work.get("isChecked")){
                    //判断是否所有作业单已通过
                    if ("2".equals(work.get("status"))){
                        licenceStatus = "2";
                    }
                }
            }
        }

        tWorkPermit.setApplyStatus(licenceStatus);
        return itWorkPermitService.updateTWorkPermit(tWorkPermit);
    }
}
