package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TDeviceInfo;
import com.zehong.system.domain.TSpecialDeviceRecord;
import com.zehong.system.domain.vo.TRepairOrderVo;
import com.zehong.system.mapper.TDeviceInfoMapper;
import com.zehong.system.mapper.TSpecialDeviceRecordMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TRepairOrderMapper;
import com.zehong.system.domain.TRepairOrder;
import com.zehong.system.service.ITRepairOrderService;

/**
 * 设备维修工单Service业务层处理
 * 
 * @author zehong
 * @date 2022-07-04
 */
@Service
public class TRepairOrderServiceImpl implements ITRepairOrderService 
{
    @Autowired
    private TRepairOrderMapper tRepairOrderMapper;
    @Autowired
    private TSpecialDeviceRecordMapper tSpecialDeviceRecordMapper;
    @Autowired
    private TDeviceInfoMapper tDeviceInfoMapper;

    /**
     * 查询设备维修工单
     * 
     * @param id 设备维修工单ID
     * @return 设备维修工单
     */
    @Override
    public TRepairOrderVo selectTRepairOrderById(Long id)
    {
        return tRepairOrderMapper.selectTRepairOrderById(id);
    }

    /**
     * 查询设备维修工单列表
     * 
     * @param tRepairOrder 设备维修工单
     * @return 设备维修工单
     */
    @Override
    public List<TRepairOrderVo> selectTRepairOrderList(TRepairOrder tRepairOrder)
    {
        return tRepairOrderMapper.selectTRepairOrderList(tRepairOrder);
    }

    /**
     * 新增设备维修工单
     * 
     * @param tRepairOrder 设备维修工单
     * @return 结果
     */
    @Override
    public int insertTRepairOrder(TRepairOrder tRepairOrder)
    {
        String repairCode = "RO" + tRepairOrderMapper.getRepairOrderCode();
        TDeviceInfo tDeviceInfo = tDeviceInfoMapper.selectTDeviceInfoById(tRepairOrder.getDeviceId());

        TSpecialDeviceRecord tSpecialDeviceRecord = new TSpecialDeviceRecord();
        tSpecialDeviceRecord.setDeviceCode(tDeviceInfo.getDeviceCode());
        tSpecialDeviceRecord.setOperateCode(repairCode);
        tSpecialDeviceRecord.setOperateType("2");
        tSpecialDeviceRecord.setRecordStatus(tRepairOrder.getOrderStatus());
        tSpecialDeviceRecordMapper.insertTSpecialDeviceRecord(tSpecialDeviceRecord);

        tRepairOrder.setRepairCode(repairCode);
        tRepairOrder.setCreateTime(DateUtils.getNowDate());
        return tRepairOrderMapper.insertTRepairOrder(tRepairOrder);
    }

    /**
     * 修改设备维修工单
     * 
     * @param tRepairOrder 设备维修工单
     * @return 结果
     */
    @Override
    public int updateTRepairOrder(TRepairOrder tRepairOrder)
    {
        TSpecialDeviceRecord tSpecialDeviceRecord = new TSpecialDeviceRecord();
        tSpecialDeviceRecord.setOperateCode(tRepairOrder.getRepairCode());
        tSpecialDeviceRecord.setRecordStatus(tRepairOrder.getOrderStatus());
        tSpecialDeviceRecord.setUpdateTime(DateUtils.getNowDate());
        tSpecialDeviceRecord.setIsDel(tRepairOrder.getIsDel());
        tSpecialDeviceRecordMapper.updateTSpecialDeviceRecord(tSpecialDeviceRecord);

        tRepairOrder.setUpdateTime(DateUtils.getNowDate());
        return tRepairOrderMapper.updateTRepairOrder(tRepairOrder);
    }

    /**
     * 批量删除设备维修工单
     * 
     * @param ids 需要删除的设备维修工单ID
     * @return 结果
     */
    @Override
    public int deleteTRepairOrderByIds(Long[] ids)
    {
        return tRepairOrderMapper.deleteTRepairOrderByIds(ids);
    }

    /**
     * 删除设备维修工单信息
     * 
     * @param id 设备维修工单ID
     * @return 结果
     */
    @Override
    public int deleteTRepairOrderById(Long id)
    {
        return tRepairOrderMapper.deleteTRepairOrderById(id);
    }
}
