package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TMapDeviceMonitorMapper;
import com.zehong.system.domain.TMapDeviceMonitor;
import com.zehong.system.service.ITMapDeviceMonitorService;

/**
 * 上图设备监测Service业务层处理
 * 
 * @author zehong
 * @date 2022-10-08
 */
@Service
public class TMapDeviceMonitorServiceImpl implements ITMapDeviceMonitorService 
{
    @Autowired
    private TMapDeviceMonitorMapper tMapDeviceMonitorMapper;

    /**
     * 查询上图设备监测
     * 
     * @param monitorId 上图设备监测ID
     * @return 上图设备监测
     */
    @Override
    public TMapDeviceMonitor selectTMapDeviceMonitorById(Long monitorId)
    {
        return tMapDeviceMonitorMapper.selectTMapDeviceMonitorById(monitorId);
    }

    /**
     * 查询上图设备监测列表
     * 
     * @param tMapDeviceMonitor 上图设备监测
     * @return 上图设备监测
     */
    @Override
    public List<TMapDeviceMonitor> selectTMapDeviceMonitorList(TMapDeviceMonitor tMapDeviceMonitor)
    {
        return tMapDeviceMonitorMapper.selectTMapDeviceMonitorList(tMapDeviceMonitor);
    }

    /**
     * 新增上图设备监测
     * 
     * @param tMapDeviceMonitor 上图设备监测
     * @return 结果
     */
    @Override
    public int insertTMapDeviceMonitor(TMapDeviceMonitor tMapDeviceMonitor)
    {
        tMapDeviceMonitor.setCreateTime(DateUtils.getNowDate());
        return tMapDeviceMonitorMapper.insertTMapDeviceMonitor(tMapDeviceMonitor);
    }

    /**
     * 修改上图设备监测
     * 
     * @param tMapDeviceMonitor 上图设备监测
     * @return 结果
     */
    @Override
    public int updateTMapDeviceMonitor(TMapDeviceMonitor tMapDeviceMonitor)
    {
        tMapDeviceMonitor.setUpdateTime(DateUtils.getNowDate());
        return tMapDeviceMonitorMapper.updateTMapDeviceMonitor(tMapDeviceMonitor);
    }

    /**
     * 批量删除上图设备监测
     * 
     * @param monitorIds 需要删除的上图设备监测ID
     * @return 结果
     */
    @Override
    public int deleteTMapDeviceMonitorByIds(Long[] monitorIds)
    {
        return tMapDeviceMonitorMapper.deleteTMapDeviceMonitorByIds(monitorIds);
    }

    /**
     * 删除上图设备监测信息
     * 
     * @param monitorId 上图设备监测ID
     * @return 结果
     */
    @Override
    public int deleteTMapDeviceMonitorById(Long monitorId)
    {
        return tMapDeviceMonitorMapper.deleteTMapDeviceMonitorById(monitorId);
    }
}
