package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TMapDeviceInfoMapper;
import com.zehong.system.domain.TMapDeviceInfo;
import com.zehong.system.service.ITMapDeviceInfoService;

/**
 * 上图设备信息Service业务层处理
 * 
 * @author zehong
 * @date 2022-10-08
 */
@Service
public class TMapDeviceInfoServiceImpl implements ITMapDeviceInfoService 
{
    @Autowired
    private TMapDeviceInfoMapper tMapDeviceInfoMapper;

    /**
     * 查询上图设备信息
     * 
     * @param mapDeviceId 上图设备信息ID
     * @return 上图设备信息
     */
    @Override
    public TMapDeviceInfo selectTMapDeviceInfoById(Long mapDeviceId)
    {
        return tMapDeviceInfoMapper.selectTMapDeviceInfoById(mapDeviceId);
    }

    /**
     * 查询上图设备信息列表
     * 
     * @param tMapDeviceInfo 上图设备信息
     * @return 上图设备信息
     */
    @Override
    public List<TMapDeviceInfo> selectTMapDeviceInfoList(TMapDeviceInfo tMapDeviceInfo)
    {
        return tMapDeviceInfoMapper.selectTMapDeviceInfoList(tMapDeviceInfo);
    }

    /**
     * 新增上图设备信息
     * 
     * @param tMapDeviceInfo 上图设备信息
     * @return 结果
     */
    @Override
    public int insertTMapDeviceInfo(TMapDeviceInfo tMapDeviceInfo)
    {
        tMapDeviceInfo.setCreateTime(DateUtils.getNowDate());
        return tMapDeviceInfoMapper.insertTMapDeviceInfo(tMapDeviceInfo);
    }

    /**
     * 修改上图设备信息
     * 
     * @param tMapDeviceInfo 上图设备信息
     * @return 结果
     */
    @Override
    public int updateTMapDeviceInfo(TMapDeviceInfo tMapDeviceInfo)
    {
        tMapDeviceInfo.setUpdateTime(DateUtils.getNowDate());
        return tMapDeviceInfoMapper.updateTMapDeviceInfo(tMapDeviceInfo);
    }

    /**
     * 批量删除上图设备信息
     * 
     * @param mapDeviceIds 需要删除的上图设备信息ID
     * @return 结果
     */
    @Override
    public int deleteTMapDeviceInfoByIds(Long[] mapDeviceIds)
    {
        return tMapDeviceInfoMapper.deleteTMapDeviceInfoByIds(mapDeviceIds);
    }

    /**
     * 删除上图设备信息信息
     * 
     * @param mapDeviceId 上图设备信息ID
     * @return 结果
     */
    @Override
    public int deleteTMapDeviceInfoById(Long mapDeviceId)
    {
        return tMapDeviceInfoMapper.deleteTMapDeviceInfoById(mapDeviceId);
    }

    /**
     * 获取所有上图设备信息
     * @param tMapDeviceInfo
     * @return
     */
    @Override
    public List<TMapDeviceInfo> deviceInfoLists(TMapDeviceInfo tMapDeviceInfo){
        return tMapDeviceInfoMapper.deviceInfoLists(tMapDeviceInfo);
    }
}
