package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TDeviceInfo;
import com.zehong.system.domain.TSpecialDeviceRecord;
import com.zehong.system.domain.vo.TMaintainPlanVo;
import com.zehong.system.mapper.TDeviceInfoMapper;
import com.zehong.system.mapper.TSpecialDeviceRecordMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TMaintainPlanMapper;
import com.zehong.system.domain.TMaintainPlan;
import com.zehong.system.service.ITMaintainPlanService;

/**
 * 设备保养计划Service业务层处理
 * 
 * @author zehong
 * @date 2022-07-04
 */
@Service
public class TMaintainPlanServiceImpl implements ITMaintainPlanService 
{
    @Autowired
    private TMaintainPlanMapper tMaintainPlanMapper;
    @Autowired
    private TSpecialDeviceRecordMapper tSpecialDeviceRecordMapper;
    @Autowired
    private TDeviceInfoMapper tDeviceInfoMapper;

    /**
     * 查询设备保养计划
     * 
     * @param id 设备保养计划ID
     * @return 设备保养计划
     */
    @Override
    public TMaintainPlanVo selectTMaintainPlanById(Long id)
    {
        return tMaintainPlanMapper.selectTMaintainPlanById(id);
    }

    /**
     * 查询设备保养计划列表
     * 
     * @param tMaintainPlan 设备保养计划
     * @return 设备保养计划
     */
    @Override
    public List<TMaintainPlanVo> selectTMaintainPlanList(TMaintainPlan tMaintainPlan)
    {
        return tMaintainPlanMapper.selectTMaintainPlanList(tMaintainPlan);
    }

    /**
     * 新增设备保养计划
     * 
     * @param tMaintainPlan 设备保养计划
     * @return 结果
     */
    @Override
    public int insertTMaintainPlan(TMaintainPlan tMaintainPlan)
    {
        String planCode = "MP" + tMaintainPlanMapper.getMaintainPlanCode();
        String[] ids = tMaintainPlan.getDeviceId().split(",");
        for(String id : ids) {
            TDeviceInfo tDeviceInfo = tDeviceInfoMapper.selectTDeviceInfoById(Long.valueOf(id));

            TSpecialDeviceRecord tSpecialDeviceRecord = new TSpecialDeviceRecord();
            tSpecialDeviceRecord.setDeviceCode(tDeviceInfo.getDeviceCode());
            tSpecialDeviceRecord.setOperateCode(planCode);
            tSpecialDeviceRecord.setOperateType("1");
            tSpecialDeviceRecord.setEffectiveDate(tMaintainPlan.getPlanEndTime());
            tSpecialDeviceRecord.setRecordStatus(tMaintainPlan.getPlanStatus());
            tSpecialDeviceRecordMapper.insertTSpecialDeviceRecord(tSpecialDeviceRecord);
        }

        tMaintainPlan.setPlanCode(planCode);
        tMaintainPlan.setCreateTime(DateUtils.getNowDate());
        return tMaintainPlanMapper.insertTMaintainPlan(tMaintainPlan);
    }

    /**
     * 修改设备保养计划
     * 
     * @param tMaintainPlan 设备保养计划
     * @return 结果
     */
    @Override
    public int updateTMaintainPlan(TMaintainPlan tMaintainPlan)
    {
        TSpecialDeviceRecord tSpecialDeviceRecord = new TSpecialDeviceRecord();
        tSpecialDeviceRecord.setOperateCode(tMaintainPlan.getPlanCode());
        tSpecialDeviceRecord.setEffectiveDate(tMaintainPlan.getPlanEndTime());
        tSpecialDeviceRecord.setRecordStatus(tMaintainPlan.getPlanStatus());
        tSpecialDeviceRecord.setUpdateTime(DateUtils.getNowDate());
        tSpecialDeviceRecord.setIsDel(tMaintainPlan.getIsDel());
        tSpecialDeviceRecordMapper.updateTSpecialDeviceRecord(tSpecialDeviceRecord);

        tMaintainPlan.setUpdateTime(DateUtils.getNowDate());
        return tMaintainPlanMapper.updateTMaintainPlan(tMaintainPlan);
    }

    /**
     * 批量删除设备保养计划
     * 
     * @param ids 需要删除的设备保养计划ID
     * @return 结果
     */
    @Override
    public int deleteTMaintainPlanByIds(Long[] ids)
    {
        return tMaintainPlanMapper.deleteTMaintainPlanByIds(ids);
    }

    /**
     * 删除设备保养计划信息
     * 
     * @param id 设备保养计划ID
     * @return 结果
     */
    @Override
    public int deleteTMaintainPlanById(Long id)
    {
        return tMaintainPlanMapper.deleteTMaintainPlanById(id);
    }
}
